% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slgf.R
\name{ms.slgf}
\alias{ms.slgf}
\title{Bayesian Model Selection with Latent Group-Based Regression Effects and Heteroscedasticity}
\usage{
ms.slgf(
  dataf,
  response,
  lgf = NA,
  usermodels,
  prior = "flat",
  het = rep(0, length(usermodels)),
  min.levels = 1
)
}
\arguments{
\item{dataf}{A data frame containing a continuous response, at least one categorical predictor, and any other covariates of interest. This data frame should not contain column names with the character string \code{group}.}

\item{response}{A character string indicating the column of \code{dataf} that contains the response.}

\item{lgf}{A character string indicating the column of `dataf` that contains the suspected latent grouping factor (SLGF).}

\item{usermodels}{A list of length \code{M} where each element contains a string of *R* class \code{formula} or \code{character} indicating the models to consider. The term \code{group} should be used to replace the name of the slgf in models with group-based regression effects. This list must contain at least one model with group-based regression effects.}

\item{prior}{A character string \code{"flat"} or \code{"zs"} indicating whether to implement the flat or Zellner-Siow mixture g-prior on regression effects, respectively. Defaults to \code{"flat"}.}

\item{het}{A vector of 0s and 1s of length \code{M}. If the mth element of \code{het} is 0, then the mth model of \code{usermodels} is considered in a homoscedastic context only; if the mth element of \code{het} is 1, the mth model of \code{usermodels} is considered in both homoscedastic and heteroscedastic contexts.}

\item{min.levels}{A numeric value indicating the minimum number of levels of the SLGF that can comprise a group. Defaults to 1.}
}
\value{
\code{ms.slgf} returns a list of six elements:\cr
    1) \code{results}, an \code{M} by 11 matrix where columns contain the model selection results and information for each model, including: \cr
    - \code{Model}, the formula associated with each model; \cr
    - \code{Scheme}, the grouping scheme associated with each model; \cr
    - \code{Variance}, a label of whether each model is homoscedastic or heteroscedastic; \cr
    - \code{logFlik}, the fractional log-likelihood associated with each model; \cr
    - \code{Mod.Prior}, the prior assigned to each model; \cr
    - \code{Fmodprob}, the fractional posterior probability associated with each model; \cr
    - \code{Cumulative}, the cumulative fractional posterior probability associated with a given model and the previous models; \cr
    - \code{dataf.Index}, an index indicating which element of \code{group.datafs} contains the corresponding group \code{dataframe}; \cr
    - \code{mle.index}, an index indicating which element of \code{coefficients}, \code{variances}, and \code{gs} contains the corresponding estimates; \cr
    - \code{Model.Index}, an index indicating where the model ranks in its posterior model probability; \cr
    - \code{Class}, a label of the model with its group variance specification; \cr
    2) \code{group.datafs}, a list containing dataframes associated with each model class containing the appropriate effects, including group effects; \cr
    3) \code{scheme.Probs}, a \code{data.frame} containing the total posterior probability for each grouping scheme considered; \cr
    4) \code{class.Probs}, a \code{data.frame} containing the total posterior probability for each model class considered; \cr
    5) \code{coefficients}, MLEs for each model's regression effects; \cr
    6) \code{variances}, MLEs based on concentrated likelihood for each model's variance(s); \cr
    7) \code{gs}, MLEs based on concentrated likelihood for each model's \code{g}; only included if \code{prior="zs"}.
}
\description{
\code{ms.slgf} Implements the model selection method proposed by \insertCite{metzger2019}{slgf}.
}
\examples{
# Fit a a heteroscedastic ANOVA example with distinct means by level of the LGF.

library(numDeriv)

set.seed(314159)
test.data <- data.frame("y"=c(rnorm(10,0,1), rnorm(10,3,1), rnorm(10,5,3)),
                        "x"=c(rep("A",10), rep("B",10), rep("C",10)))
test.models <- list("y~1", "y~x", "y~group")
test.out <- ms.slgf(dataf=test.data, response="y", lgf="x",
                    usermodels=test.models,
                    prior="flat", het=c(1,1,1), min.levels=1)
test.out$results[1:3,c(1:4,6,7)]
}
\references{
\insertRef{metzger2019}{slgf}
}
\author{
Thomas A. Metzger and Christopher T. Franck
}
