% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_point_data.R
\name{get_soils_point}
\alias{get_soils_point}
\title{Get SLGA point data}
\usage{
get_soils_point(
  product = NULL,
  attribute = NULL,
  component = "ALL",
  depth = NULL,
  poi = NULL,
  buff = 0L,
  buff_shp = c("square", "circle"),
  stat = "median"
)
}
\arguments{
\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}, where Type =
'Soil'.}

\item{attribute}{Character, one of the options from column 'Code' in
\code{\link[slga:slga_attribute_info]{slga_attribute_info}}}

\item{component}{Character, one of the following:
\itemize{
 \item 'VAL' - predicted value surface.
 \item 'CLO' - lower 95\% confidence interval surface.
 \item 'CHI' - upper 95\% confidence interval surface.
 \item 'CIS' - both confidence interval surfaces.
 \item 'ALL' - value and confidence interval surfaces.
 }
 Defaults to 'ALL'.}

\item{depth}{Integer, a number from 1 to 6. The numbers correspond to the
 following depth ranges:
\enumerate{
 \item 0 to 5 cm.
 \item 5 to 15 cm.
 \item 15 to 30 cm.
 \item 30 to 60 cm.
 \item 60 to 100 cm.
 \item 100 to 200 cm.
 }}

\item{poi}{WGS84 coordinates defining a point of interest. Supply an
sf-style point object (length-1 sfg or sfc, or single-row sf data frame) or
 a length-2 numeric vector (x, y).}

\item{buff}{Length-1 integer. Use if a summarised value around a point is desired.
Defaults to 0L, which returns the exact value(s) of the pixel under the `poi`.
A `buff` value of 1 will return a summary of the pixels in a one-cell range,
etc.}

\item{buff_shp}{One of 'square' or 'circle'. Use with buff > 0.
Defaults to 'square', in which case all values within the buffer are
summarised. A circular mask is applied to the data before summarising
otherwise.}

\item{stat}{Summary method applied where buff > 0. Defaults to median. Other
options include mean, modal, min, max, sd, IQR, quantile, and summary.}
}
\value{
An data.frame with requested values.
}
\description{
Get SLGA modelled soil data at a point location.
}
\note{
If you have many points within a relatively small area, it will likely
be more efficient to grab a raster covering the whole area and extract
summary values yourself.
}
\examples{
\donttest{
 # get predicted clay value for 60-100cm at a point
 clay_pt <- get_soils_point('NAT', 'CLY', 'VAL', 5, c(153,-27.5))

 # get the average predicted clay content for 60-100cm within ~300m
 avg_clay <- get_soils_point('NAT', 'CLY', 'ALL', 5, c(153, -27.5),
                             buff = 3, buff_shp = 'circle', stat = 'mean')
 }
}
