% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{star}
\alias{star}
\title{Create \emph{skyscapeR.star} object}
\usage{
star(string, year)
}
\arguments{
\item{string}{This can be either: 1) the common name for the star,
2) the Hipparchos catalogue number (if string begins with HIP),
3) the Bright Star Catalogue number (if string begins with HR),
4) the Messier catalogue number (if string begins with M), or
5) the Bayer designation (if string has exactly 5 characters,
 the second of which is a space).}

\item{year}{Year for which to calculate the coordinates.
Defaults to J2000.0 epoch.}
}
\description{
This function retrieves information for a given star
and saves it in the \emph{skyscapeR.star} format ready to be
used by other skyscapeR package function.
}
\examples{
# Retrieve data for Aldebaran:
Aldeb <- star('Aldebaran')

# Retrieve data for the Pleiades (M45):
P1 <- star('Pleiades')
P2 <- star('M45')

# Retrieve data for Sirius on 2999 BC:
ss <- star('Sirius', -3000)
}
\seealso{
\code{\link[astrolibR]{precess}}, \code{\link[astrolibR]{co_nutate}},
\code{\link[astrolibR]{co_aberration}}
}
