% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.skpr_eval_output}
\alias{print.skpr_eval_output}
\title{Print evaluation information}
\usage{
\method{print}{skpr_eval_output}(x, ...)
}
\arguments{
\item{x}{The x of the evaluation functions in skpr}

\item{...}{Additional arguments.}
}
\description{
Prints design evaluation information below the dataframe of power values
}
\examples{
#Generate/evaluate a design and print it's information
factorialcoffee = expand.grid(cost = c(1, 2),
                              type = as.factor(c("Kona", "Colombian", "Ethiopian", "Sumatra")),
                              size = as.factor(c("Short", "Grande", "Venti")))

designcoffee = gen_design(factorialcoffee,
                         ~cost + size + type, trials = 29, optimality = "D", repeats = 100)

eval_design(designcoffee)
}
