% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlations.R
\name{plot_correlations}
\alias{plot_correlations}
\title{Plots design diagnostics}
\usage{
plot_correlations(genoutput, model = NULL, customcolors = NULL,
  pow = 2, custompar = NULL)
}
\arguments{
\item{genoutput}{The output of either gen_design or eval_design/eval_design_mc}

\item{model}{Default NULL. If specified, it will override the default model used to generate/evaluate the design.}

\item{customcolors}{A vector of colors for customizing the appearance of the colormap}

\item{pow}{Default 2. The interaction level that the correlation map is showing.}

\item{custompar}{Default NULL. Custom parameters to pass to the `par` function for base R plotting.}
}
\value{
Silently returns the correlation matrix with the proper row and column names.
}
\description{
Plots design diagnostics
}
\examples{
#We can pass either the output of gen_design or eval_design to plot_correlations
#in order to obtain the correlation map. Passing the output of eval_design is useful
#if you want to plot the correlation map from an externally generated design.

#First generate the design:

candidatelist = expand.grid(cost = c(15000, 20000), year = c("2001", "2002", "2003", "2004"),
                           type = c("SUV", "Sedan", "Hybrid"))
cardesign = gen_design(candidatelist, ~(cost+type+year)^2, 30)
plot_correlations(cardesign)

#We can also increase the level of interactions that are shown by default.

plot_correlations(cardesign, pow = 3)

#You can also pass in a custom color map.
plot_correlations(cardesign, customcolors = c("blue", "grey", "red"))
plot_correlations(cardesign, customcolors = c("blue", "green", "yellow", "orange", "red"))
}
