% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{vcov.sklarsomega}
\alias{vcov.sklarsomega}
\title{Compute an estimated covariance matrix for a Sklar's Omega fit.}
\usage{
\method{vcov}{sklarsomega}(object, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{...}{additional arguments.}
}
\value{
A matrix of estimated variances and covariances for the parameter estimator. This should have row and column names corresponding to the parameter names given by the \code{\link{coef}} method. Note that a call to this function will result in an error if \code{\link{sklars.omega}} was called with argument \code{confint} equal to \code{"none"}, or if optimization failed.
}
\description{
Compute an estimated covariance matrix for a Sklar's Omega fit.
}
\details{
See the package vignette for detailed information regarding covariance estimation for Sklar's Omega.
}
\examples{
# Fit a subset of the cartilage data, assuming a Laplace marginal distribution. Compute
# confidence intervals in the usual ML way (observed information matrix).

data(cartilage)
data = as.matrix(cartilage)[1:100, ]
colnames(data) = c("c.1.1", "c.2.1")
fit = sklars.omega(data, level = "interval", confint = "asymptotic",
                   control = list(dist = "laplace"))
summary(fit)
vcov(fit)
}
\references{
Nissi, M. J., Mortazavi, S., Hughes, J., Morgan, P., and Ellermann, J. (2015). T2* relaxation time of acetabular and femoral cartilage with and without intra-articular Gd-DTPA2 in patients with femoroacetabular impingement. \emph{American Journal of Roentgenology}, \bold{204}(6), W695.
}

