\name{MeetIrrEl}
\Rdversion{1.1}
\alias{MeetIrrEl}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Meet-irreducible elements
}
\description{
\code{MeetIrrEl} computes the meet-irreducible elements of (a subset of) a knowledge structure.
}
\usage{
MeetIrrEl(KS)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{KS}{
(Subset of) a knowledge structure in 'set' or 'matrix' representation (cf. \link[skills]{skills-package})
}
}
\details{
The meet-irreducible elements of a knowledge structure are a minimal set of states in \code{KS}
which have the same closure under intersection as \code{KS} itself.\cr
Especially in the case of a closure space \code{KS} the latter one is generated by its meet-irreducible elements.
}
\value{
A subset of the knowledge structure \code{KS} either in  'set of sets' - representation if \code{KS} is 'set' or 'gset'
or in 'matrix' representation if \code{KS} is a matrix.
}
\references{
Duentsch, I., Gediga, G. (2002), \emph{Skill Set Analysis in Knowledge Structures}. British Journal of Mathematical and
Statistical Psychology, 55(2), 361 - 384.
}
\author{
Angela Haidinger \email{angela.ulrike.haidinger@student.uni-augsburg.de},\cr
Ali Uenlue \email{uenlue@statistik.tu-dortmund.de}
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[sets]{closure}} also contains information for the function \code{reduction} which is called by this function
in order to compute the meet-irreducible elements by setting parameter\cr
\code{operation = "intersection"}.
}
\examples{
KS1 = matrix(c(0,0,0,0,1,0,0,0,1,1,0,1,1,1,1), nrow = 3)
rownames(KS1) = letters[c(2,3,6)]
MeetIrrEl(KS1)

KS2 = set(set(), set("c"), set("f"), set("b","f"), set("a","c","d","f"),
    set("a","b","c","d","f"))
MeetIrrEl(KS2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{knowledge structure}
