% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.funcs.R
\name{analysis.funcs}
\alias{analysis.funcs}
\alias{analysisFunc}
\alias{loadResultsMatrix}
\alias{formatOverallStats}
\alias{globalAnalysis}
\alias{locusAnalysisGenotypes}
\alias{hapSmryFunc}
\alias{locusAnalysisHaplotypes}
\alias{calcChordDist}
\alias{pairwiseAnalysis}
\title{Analysis functions for skeleSim parameter objects}
\usage{
analysisFunc(params)

loadResultsMatrix(params, mat, label)

formatOverallStats(g, num.perm.reps)

globalAnalysis(g, num.perm.reps)

locusAnalysisGenotypes(g)

hapSmryFunc(g)

locusAnalysisHaplotypes(g)

calcChordDist(dat)

pairwiseAnalysis(g, num.perm.reps)
}
\arguments{
\item{params}{a \linkS4class{skeleSim.params} object.}

\item{mat}{results matrix to be loaded into params object.}

\item{label}{analysis type label ("Global", "Locus", or "Pairwise").}

\item{g}{a \linkS4class{gtypes} object.}

\item{num.perm.reps}{number of permutation replicates.}

\item{dat}{data.frame in hierfstat format (see \code{\link[hierfstat]{genet.dist}}).}
}
\description{
Run Global, Locus, and Pairwise analyses on results from
  a single simulation replicate stored in params@rep.sample#'
}
