#' Probability distribution for number of peaks in a continuous,
#' uncorrelated stochastic series
#'
#' A dataset containing the probability mass function for the distribution of
#' the number of peaks in a continuous, uncorrelated stochastic series. These
#' probabilities were generated from the \code{\link{dpeak}} function.
#' This function is computationally very slow for \eqn{n > 170}; thus the
#' functions of \code{skedastic} package that require peak probabilities
#' (\code{\link{ppeak}} and \code{\link{goldfeld_quandt}}) by default
#' obtain the probabilities from this data set rather than from
#' \code{\link{dpeak}}, provided that \eqn{n \leq 1000}.
#'
#' @format A list of 1000 objects. The \eqn{n}th object is a double vector
#' of length \eqn{n}, with elements representing the probability of \eqn{k}
#' peaks for \eqn{k=0,1,\ldots,n-1}.
"dpeakdat"

#' Pseudorandom numbers from Asymptotic Null Distribution of Test Statistic for
#' Method of \insertCite{Rackauskas07;textual}{skedastic}
#'
#' A matrix of \eqn{2 ^ 14} rows and 16 columns. Each column contains
#' \eqn{2 ^ 14} Monte Carlo replicates from the distribution of
#' \eqn{T_{\alpha}} for a particular value of \eqn{\alpha}, \eqn{\alpha=i/32},
#' \eqn{i=0,1,\ldots,15}. The values were generated by first generating a
#' Brownian Bridge using \eqn{m = 2 ^ 17} standard normal variates and then
#' applying Equation (11) from \insertCite{Rackauskas07;textual}{skedastic}.
#' It can be used to compute empirical approximate \eqn{p}-values for
#' implementation of the Rackauskas-Zuokas Test for heteroskedasticity. This
#' is a time-saving measure because, while \code{\link{rackauskas_zuokas}}
#' contains an option for simulating the \eqn{p}-value directly, this would be
#' computationally intensive for the authors' recommended \eqn{m} of
#' \eqn{2 ^ 17}. Passing the argument \code{pvalmethod = "data"} to
#' \code{\link{rackauskas_zuokas}} instructs the function to use the
#' pre-generated values in this data set to compute the empirical approximate
#' \eqn{p}-value for the test.
"T_alpha"
