\name{skatExample}
\alias{skatExample}
\alias{Z1}
\alias{Z2}
\alias{pheno1}
\alias{pheno2}
\alias{kins}
\docType{data}
\title{
%%   ~~ data name/kind ... ~~
example Data for illustrating skatMeta 
}
\description{
Contains simulated data for two cohorts.  See the example for the exact code used to generate the data.
}
\usage{data(skatExample)}
\format{
	This contains simulated data for two cohorts to illustrate skatMeta package
  \describe{
    \item{\code{Z2},\code{Z1}}{
    	Genotype matrices for cohorts 1 and 2 respectively
    }
    \item{\code{pheno1},\code{pheno2}}{
    	phenotype matrices for cohorts 1 and 2 respectively
    }
    \item{kins}{
    	The kinship matrix for cohort 2
    }
  }
}

\examples{
#Data generated by
\dontrun{
set.seed(20)
data(SNPInfo)
n <- 600 #observations per cohort
d <- 2000 #SNPs

Z1 <- replicate(d,rbinom(n,2,rbeta((n),3,200)))

colnames(Z1) <- sample(d+50,d) + 1e6

pheno1 <-  data.frame("y" = rnorm(n), "sex"=rep(1:2,(n/2)), "bmi"=rnorm(n,25,2),"ybin" = rbinom(n,1,.5), "time"=rpois(n,5), 
              "status"=rbinom(n,1,.9))
SNPInfo <- data.frame("Name" =1:(d+50) + 1e6, "gene" = sort(sample(unique(SNPInfo$SKATgene)[1:100],d+50,replace=T)))

###family data:
require(kinship2)
fullped<-data.frame(famid=rep(1:(n/4),each=4),id=10001:(10000+n),fa=rep(0,n),mo=rep(0,n))
fullped$fa[(1:(n/4))*4-1]<-fullped$fa[(1:(n/4))*4]<-(1:(n/4))*4+9997
fullped$mo[(1:(n/4))*4-1]<-fullped$mo[(1:(n/4))*4]<-(1:(n/4))*4+9998
kins = makekinship(fullped$famid, fullped$id, fullped$fa, fullped$mo)
pheno2<-data.frame("id"=10001:(10000+n),"y"=t(rnorm(n)\%*\%chol(0.2*2*as.matrix(kins) + 0.8*diag(n))),"sex"=rep(1:2,(n/2)),"bmi"=rnorm(n,25,2))

Z2 <- replicate(d,rbinom(n,2,rbeta((n/4),3,200)[fullped$famid]))
colnames(Z2) <- sample(d+50,d) + 1e6
}
}
\keyword{datasets}