% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_var.R
\name{split_var}
\alias{split_var}
\title{Split numeric variables into smaller groups}
\usage{
split_var(x, ..., groupcount, as.num = FALSE, val.labels = NULL,
  var.label = NULL, inclusive = FALSE, append = FALSE, suffix = "_g")
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{groupcount}{The new number of groups that \code{x} should be split into.}

\item{as.num}{Logical, if \code{TRUE}, return value will be numeric, not a factor.}

\item{val.labels}{Optional character vector, to set value label attributes
of recoded variable (see vignette \href{../doc/intro_sjmisc.html}{Labelled Data and the sjmisc-Package}).
If \code{NULL} (default), no value labels will be set. Value labels
can also be directly defined in the \code{rec}-syntax, see
'Details'.}

\item{var.label}{Optional string, to set variable label attribute for the
returned variable (see vignette \href{../doc/intro_sjmisc.html}{Labelled Data and the sjmisc-Package}).
If \code{NULL} (default), variable label attribute of \code{x} will
be used (if present). If empty, variable label attributes will be removed.}

\item{inclusive}{Logical; if \code{TRUE}, cut point value are included in
the preceeding group. This may be necessary if cutting a vector into
groups does not define proper ("equal sized") group sizes.
See 'Note' and 'Examples'.}

\item{append}{Logical, if \code{TRUE} and \code{x} is a data frame,
\code{x} including the new variables as additional columns is returned;
if \code{FALSE} (the default), only the new variables are returned.}

\item{suffix}{String value, will be appended to variable (column) names of
\code{x}, if \code{x} is a data frame. If \code{x} is not a data
frame, this argument will be ignored. The default value to suffix
column names in a data frame depends on the function call:
\itemize{
  \item recoded variables (\code{rec()}) will be suffixed with \code{"_r"}
  \item recoded variables (\code{recode_to()}) will be suffixed with \code{"_r0"}
  \item dichotomized variables (\code{dicho()}) will be suffixed with \code{"_d"}
  \item grouped variables (\code{split_var()}) will be suffixed with \code{"_g"}
  \item grouped variables (\code{group_var()}) will be suffixed with \code{"_gr"}
  \item standardized variables (\code{std()}) will be suffixed with \code{"_z"}
  \item centered variables (\code{center()}) will be suffixed with \code{"_c"}
}}
}
\value{
A grouped variable with equal sized groups. If \code{x} is a data frame,
        for \code{append = TRUE}, \code{x} including the grouped variables
        as new columns is returned; if \code{append = FALSE}, only
        the grouped variables will be returned.
}
\description{
Recode numeric variables into equal sized groups, i.e. a
               variable is cut into a smaller number of groups at
               specific cut points.
}
\details{
\code{split_var()} splits a variable into equal sized groups, where the
           amount of groups depends on the \code{groupcount}-argument. Thus,
           this functions \code{\link{cut}s} a variable into groups at the
           specified \code{\link[stats]{quantile}s}.
           \cr \cr
           By contrast, \code{\link{group_var}} recodes a variable into
           groups, where groups have the same value range
           (e.g., from 1-5, 6-10, 11-15 etc.).
}
\note{
In case a vector has only few number of unique values, splitting into
        equal sized groups may fail. In this case, use the \code{inclusive}-argument
        to shift a value at the cut point into the lower, preceeding group to
        get equal sized groups. See 'Examples'.
}
\examples{
data(efc)
# non-grouped
table(efc$neg_c_7)

# split into 3 groups
table(split_var(efc$neg_c_7, groupcount = 3))

# split multiple variables into 3 groups
split_var(efc, neg_c_7, pos_v_4, e17age, groupcount = 3)
frq(split_var(efc, neg_c_7, pos_v_4, e17age, groupcount = 3))

# original
table(efc$e42dep)

# two groups, non-inclusive cut-point
# vector split leads to unequal group sizes
table(split_var(efc$e42dep, groupcount = 2))

# two groups, inclusive cut-point
# group sizes are equal
table(split_var(efc$e42dep, groupcount = 2, inclusive = TRUE))

}
\seealso{
\code{\link{group_var}} to group variables into equal ranged groups,
         or \code{\link{rec}} to recode variables.
}
