% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dicho.R
\name{dicho}
\alias{dicho}
\title{Dichotomize variables}
\usage{
dicho(x, dich.by = "median", dich.val = -1, as.num = FALSE,
  var.label = NULL, val.labels = NULL, dichBy, dichVal, asNum)
}
\arguments{
\item{x}{Variable (vector), \code{data.frame} or \code{list} of variables
that should be dichotomized}

\item{dich.by}{Indicates the split criterion where a variable is dichotomized
\describe{
  \item{\code{"median"}}{by default, \code{x} is split into two groups at the median. May be abbreviated as \code{"md"}.}
  \item{\code{"mean"}}{splits \code{x} into two groups at the mean of \code{x}. May be abbreviated as \code{"m"}.}
  \item{\code{"value"}}{splits \code{x} into two groups at a specific value (see \code{dich.val}). May be abbreviated as \code{"v"}.}
  }}

\item{dich.val}{Numeric, indicates a value where \code{x} is dichotomized when \code{dich.by = "value"}.
\strong{Note that \code{dich.val} is inclusive}, i.e. \code{dich.val = 10} will split \code{x}
into one group with values from lowest to 10 and another group with values greater
than 10.}

\item{as.num}{Logical, if \code{TRUE}, return value will be numeric, not a factor.}

\item{var.label}{Optional string, to set variable label attribute for the
dichotomized variable (see \code{\link{set_label}}). If \code{NULL}
(default), variable label attribute of \code{x} will be used (if present).}

\item{val.labels}{Optional character vector (of length two), to set value label
attributes of dichotomized variable (see \code{\link{set_labels}}).
If \code{NULL} (default), no value labels will be set.}

\item{dichBy}{deprecated; use \code{dich.by} instead}

\item{dichVal}{deprecated; use \code{dich.val} instead}

\item{asNum}{deprecated; use \code{as.num} instead}
}
\value{
A dichotomized factor (or numeric, if \code{as.num = TRUE}) variable (0/1-coded),
          respectively a data frame or list of dichotomized factor (or numeric) variables.
}
\description{
Dichotomizes variables into dummy variables (0/1). Dichotomization is
               either done by median, mean or a specific value (see \code{dich.by}).
               Either single vectors, a complete data frame or a list of
               variables can be dichotomized.
}
\note{
Variable label attributes (see, for instance, \code{\link{set_label}}) are preserved
        (unless changes via \code{var.label}-argument).
}
\examples{
data(efc)
summary(efc$c12hour)
table(dicho(efc$c12hour))
table(dicho(efc$c12hour, "mean"))
table(dicho(efc$c12hour, "value", 30))

# sample data frame, values from 1-4
head(efc[, 6:10])
# dichtomized values (1 to 2 = 0, 3 to 4 = 1)
head(dicho(efc[, 6:10], "v", 2))

# dichtomize several variables in a list
dummy <- list(efc$c12hour, efc$e17age, efc$c160age)
dicho(dummy)

# dichotomize and set labels. requires package
# sjPlot to test
\dontrun{
library(sjPlot)
sjp.frq(dicho(efc$e42dep,
              var.label = "Dependency (dichotomized)",
              val.labels = c("lower", "higher")))}
}

