% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjStatistics.R
\name{rmse}
\alias{rmse}
\title{Compute root mean squared error (RMSE)}
\usage{
rmse(fit, normalized = FALSE)
}
\arguments{
\item{fit}{a fitted linear model of class \code{\link{lm}},
\code{\link[lme4]{merMod}} (lme4) or \code{\link[nlme]{lme}} (nlme).}

\item{normalized}{logical, use \code{TRUE} if normalized rmse should be returned.}
}
\value{
The root mean squared error of \code{fit}; or the normalized
          root mean squared error of \code{fit} if \code{normalized = TRUE}.
}
\description{
Compute root mean squared error  of fitted linear (mixed effects) models.
}
\note{
The RMSE is the square root of the variance of the residuals and indicates
        the absolute fit of the model to the data (difference between observed data
        to model's predicted values). "RMSE can be interpreted as the standard
        deviation of the unexplained variance, and has the useful property
        of being in the same units as the response variable. Lower values
        of RMSE indicate better fit. RMSE is a good measure of how accurately
        the model predicts the response, and is the most important criterion
        for fit if the main purpose of the model is prediction."
        (Grace-Martin K: Assessing the Fit of Regression Models).
        \cr \cr
        The normalized RMSE is the proportion of the RMSE related to the
        range of the response variable. Hence, lower values indicate
        less residual variance.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c160age + c12hour, data = efc)
rmse(fit)

library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
rmse(fit)

# normalized RMSE
library(nlme)
fit <- lme(distance ~ age, data = Orthodont) # random is ~ age
rmse(fit, normalized = TRUE)
}
\references{
\itemize{
             \item \href{http://en.wikipedia.org/wiki/Root-mean-square_deviation}{Wikipedia: RMSD}
             \item \href{http://www.theanalysisfactor.com/assessing-the-fit-of-regression-models/}{Grace-Martin K: Assessing the Fit of Regression Models}
            }
}
\seealso{
\code{\link{cv}}
}

