% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{recode_to}
\alias{recode_to}
\title{Recode variable categories into new values.}
\usage{
recode_to(x, lowest = 0, highest = -1)
}
\arguments{
\item{x}{A variable (vector) or a data frame that should be recoded.}

\item{lowest}{Indicating the lowest category value after recoding. Default is 0, so the new
variable starts with the category value 0.}

\item{highest}{If specified and larger than \code{lowest}, all category values larger than
\code{highest} will be set to \code{NA}. Default is \code{-1}, i.e. this parameter is ignored
and no NA's will be produced.}
}
\value{
A new variable with recoded category values, where \code{lowest} indicates the lowest
          value; or a data frame where variables have been recoded as described.
}
\description{
Recodes (or "renumbers") the categories of \code{var} into new category values, beginning
               with the lowest value specified by parameter \code{lowest}. Useful if you want
               to recode dummy variables with 1/2 coding to 0/1 coding, or recoding scales from
               1-4 to 0-3 etc.
}
\note{
Value and variable label attributes (see, for instance, \code{\link{get_val_labels}}
        or \code{\link{set_val_labels}}) are retained.
}
\examples{
# recode 1-4 to 0-3
dummy <- sample(1:4, 10, replace = TRUE)
recode_to(dummy)

# recode 3-6 to 0-3
# note that numeric type is returned
dummy <- as.factor(3:6)
recode_to(dummy)

# lowest value starting with 1
dummy <- sample(11:15, 10, replace = TRUE)
recode_to(dummy, 1)

# lowest value starting with 1, highest with 3
# all others set to NA
dummy <- sample(11:15, 10, replace = TRUE)
recode_to(dummy, 1, 3)
}
\seealso{
\code{\link{rec}} for general recoding of variables and \code{\link{set_na}}
           for setting \code{\link{NA}} values.
}

