% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{anova.sjSDM}
\alias{anova.sjSDM}
\title{Anova}
\usage{
\method{anova}{sjSDM}(object, samples = 5000L, ...)
}
\arguments{
\item{object}{model of object \code{\link{sjSDM}}}

\item{samples}{Number of Monte Carlo samples}

\item{...}{optional arguments which are passed to the calculation of the logLikelihood}
}
\value{
An S3 class of type 'sjSDManova' including the following components:

\item{results}{Data frame of results.}
\item{to_print}{Data frame, summarized results for type I anova.}
\item{N}{Number of observations (sites).}
\item{spatial}{Logical, spatial model or not.}
\item{species}{individual species R2s.}
\item{sites}{individual site R2s.}
\item{lls}{individual site by species negative-log-likelihood values.}

Implemented S3 methods are \code{\link{print.sjSDManova}} and \code{\link{plot.sjSDManova}}
}
\description{
Calculate type II anova.


Shared contributions (e.g. between space and environment) are also calculated and can be visualized via \code{\link{plot.sjSDManova}}.
}
\details{
Compute analysis of variance
}
\seealso{
\code{\link{plot.sjSDManova}}, \code{\link{print.sjSDManova}}, \code{\link{plotInternalStructure}}
}
