% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabLinReg.R
\name{sjt.lmer}
\alias{sjt.lmer}
\title{Summary of linear mixed effects models as HTML table}
\usage{
sjt.lmer(..., file = NULL, labelPredictors = NULL,
  labelDependentVariables = NULL, stringPredictors = "Predictors",
  stringDependentVariables = "Dependent Variables", stringModel = "Model",
  showHeaderStrings = FALSE, stringIntercept = "(Intercept)",
  stringObservations = "Observations", stringB = "B",
  stringSB = "std. Beta", stringCI = "CI", stringSE = "std. Error",
  stringP = "p", showEst = TRUE, showConfInt = TRUE,
  showStdBeta = FALSE, showStdError = FALSE,
  ci.hyphen = "&nbsp;&ndash;&nbsp;", minus.sign = "&#45;", digits.est = 2,
  digits.p = 3, digits.ci = 2, digits.se = 2, digits.sb = 2,
  digits.summary = 3, pvaluesAsNumbers = TRUE, boldpvalues = TRUE,
  separateConfColumn = TRUE, newLineConf = TRUE, group.pred = FALSE,
  showAbbrHeadline = TRUE, showR2 = TRUE, showICC = TRUE,
  showREvar = TRUE, showAIC = FALSE, showAICc = FALSE,
  showDeviance = TRUE, remove.estimates = NULL, cellSpacing = 0.2,
  cellGroupIndent = 0.6, encoding = NULL, CSS = NULL, useViewer = TRUE,
  no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{...}{one or more fitted linear (mixed) models.}

\item{file}{destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and 
openend either in the IDE's viewer pane or the default web browser.}

\item{labelPredictors}{character vector with labels of predictor variables.
If not \code{NULL}, \code{labelPredictors} will be used in the first
table column with the predictors' names. See 'Examples'.}

\item{labelDependentVariables}{character vector with labels of dependent 
variables of all fitted models. See 'Examples'.}

\item{stringPredictors}{string constant used as headline for the predictor column.
Default is \code{"Predictors"}.}

\item{stringDependentVariables}{string constant used as headline for the 
dependent variable columns. Default is \code{"Dependent Variables"}.}

\item{stringModel}{string constant used as headline for the model names in case no 
labels for the dependent variables are provided (see \code{labelDependentVariables}).
Default is \code{"Model"}.}

\item{showHeaderStrings}{logical, if \code{TRUE}, the header strings \code{stringPredictors}
and \code{stringDependentVariables} are shown. By default, they're hidden.}

\item{stringIntercept}{string constant used as headline for the Intercept row.
Default is \code{"Intercept"}.}

\item{stringObservations}{string constant used in the summary row for the count of observation
(cases). Default is \code{"Observations"}.}

\item{stringB}{string used for the column heading of estimates. Default is \code{"B"}.}

\item{stringSB}{string used for the column heading of standardized beta coefficients. Default is \code{"std. Beta"}.}

\item{stringCI}{string used for the column heading of confidence interval values. Default is \code{"CI"}.}

\item{stringSE}{string used for the column heading of standard error values. Default is \code{"std. Error"}.}

\item{stringP}{string used for the column heading of p values. Default is \code{"p"}.}

\item{showEst}{logical, if \code{TRUE} (default), the estimates are printed.}

\item{showConfInt}{logical, if \code{TRUE} (default), the confidence intervall is also printed to the table. Use
\code{FALSE} to omit the CI in the table.}

\item{showStdBeta}{indicates whether standardized beta-coefficients should 
also printed, and if yes, which type of standardization is done.
See 'Details'.}

\item{showStdError}{logical, if \code{TRUE}, the standard errors are also printed.
Default is \code{FALSE}.}

\item{ci.hyphen}{string, indicating the hyphen for confidence interval range.
May be an HTML entity. See 'Examples'.}

\item{minus.sign}{string, indicating the minus sign for negative numbers.
May be an HTML entity. See 'Examples'.}

\item{digits.est}{amount of decimals for estimates}

\item{digits.p}{amount of decimals for p-values}

\item{digits.ci}{amount of decimals for confidence intervals}

\item{digits.se}{amount of decimals for standard error}

\item{digits.sb}{amount of decimals for standardized beta}

\item{digits.summary}{amount of decimals for values in model summary}

\item{pvaluesAsNumbers}{logical, if \code{TRUE}, p-values are shown as numbers. If \code{FALSE} (default),
p-values are indicated by asterisks.}

\item{boldpvalues}{logical, if \code{TRUE} (default), significant p-values are shown bold faced.}

\item{separateConfColumn}{if \code{TRUE}, the CI values are shown in a separate table column.
Default is \code{FALSE}.}

\item{newLineConf}{logical, if \code{TRUE} and \code{separateConfColumn = FALSE}, inserts a line break
between B and CI values. If \code{FALSE}, CI values are printed in the same
line as B values.}

\item{group.pred}{logical, if \code{TRUE} (default), automatically groups table rows with 
factor levels of same factor, i.e. predictors of type \code{\link{factor}} will
be grouped, if the factor has more than two levels. Grouping means that a separate headline
row is inserted to the table just before the predictor values.}

\item{showAbbrHeadline}{logical, if \code{TRUE} (default), the table data columns have a headline with 
abbreviations for estimates and std. beta-values, confidence interval and p-values.}

\item{showR2}{logical, if \code{TRUE} (default), the R2 and adjusted R2 values for each model are printed
in the model summary. For linear mixed models, the R2 and Omega-squared values are printed
(see \code{\link[sjmisc]{r2}} for details).}

\item{showICC}{logical, if \code{TRUE}, the intra-class-correlation for each 
model is printed in the model summary. Only applies to mixed models.}

\item{showREvar}{logical, if \code{TRUE}, the variance parameters for the random
effects for each model are printed in the model summary. Only applies to mixed models.}

\item{showAIC}{logical, if \code{TRUE}, the AIC value for each model is printed
in the model summary. Default is \code{FALSE}.}

\item{showAICc}{logical, if \code{TRUE}, the second-order AIC value for each model 
is printed in the model summary. Default is \code{FALSE}.}

\item{showDeviance}{logical, if \code{TRUE}, the deviance for each model 
is printed in the model summary.}

\item{remove.estimates}{numeric vector with indices (order equals to row index of \code{coef(fit)}) 
or character vector with coefficient names that indicate which estimates should be removed
from the table output. The first estimate is the intercept, followed by the model predictors.
\emph{The intercept cannot be removed from the table output!} \code{remove.estimates = c(2:4)} 
would remove the 2nd to the 4th estimate (1st to 3rd predictor after intercept) from the output. 
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default 
is \code{NULL}, i.e. all estimates are printed.}

\item{cellSpacing}{numeric, inner padding of table cells. By default, this value is 0.2 (unit is cm), which is
suitable for viewing the table. Decrease this value (0.05 to 0.1) if you want to import the table
into Office documents. This is a convenient argument for the \code{CSS} argument for changing
cell spacing, which would be: \code{CSS = list(css.thead = "padding:0.2cm;", css.tdata = "padding:0.2cm;")}.}

\item{cellGroupIndent}{indent for table rows with grouped factor predictors. Only applies
if \code{group.pred = TRUE}.}

\item{encoding}{string, indicating the charset encoding used for variable and 
value labels. Default is \code{NULL}, so encoding will be auto-detected 
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{CSS}{\code{\link{list}}-object with user-defined style-sheet-definitions, according to the 
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Summarizes (multiple) fitted linear mixed effects models 
               (estimates, std. beta values etc.)  as HTML table, 
               or saves them as file. The fitted models may have different 
               predictors, e.g. when comparing different stepwise fitted models.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
Computation of p-values (if necessary) are based on conditional F-tests
        with Kenward-Roger approximation for the df, using the \pkg{pbkrtest}-package.
        If \pkg{pbkrtest} is not available, Wald chi-squared tests from the 
        \code{Anova}-function of the \pkg{car}-package are computed.
        \cr \cr
        The variance components of the random parts (see \code{showREvar}) are
        denoted like:
        \itemize{
         \item within-group variance: sigma-squared
         \item between-group-variance: tau-zero-zero
         \item random-slope-intercept-correlation: rho-zero-one
         }
}
\examples{
\dontrun{
library(lme4)
library(sjmisc)
data(efc)

# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_labels(efc$e15relat)
efc$care.level <- as.factor(sjmisc::rec(efc$n4pstu, "0=0;1=1;2=2;3:4=4"))
levels(x = efc$care.level) <- c("none", "I", "II", "III")

# data frame for fitted model
mydf <- data.frame(neg_c_7 = as.numeric(efc$neg_c_7),
                   sex = as.factor(efc$c161sex),
                   c12hour = as.numeric(efc$c12hour),
                   barthel = as.numeric(efc$barthtot),
                   education = as.factor(efc$c172code),
                   grp = efc$grp,
                   carelevel = efc$care.level)
                   
# fit two sample models
fit1 <- lmer(neg_c_7 ~ sex + c12hour + barthel + (1|grp), data = mydf)
fit2 <- lmer(neg_c_7 ~ sex + c12hour + education + barthel + (1|grp), data = mydf)
fit3 <- lmer(neg_c_7 ~ sex + c12hour + education + barthel + 
              (1|grp) + 
              (1|carelevel), data = mydf)

# print summary table
sjt.lmer(fit1, fit2,
         ci.hyphen = " to ",
         minus.sign = "&minus;")

sjt.lmer(fit1, fit2,
         showAIC = TRUE,
         showConfInt = FALSE,
         showStdError = TRUE,
         pvaluesAsNumbers = FALSE)
           
sjt.lmer(fit1, fit2, fit3, 
         showAIC = TRUE,
         separateConfColumn = FALSE,
         newLineConf = FALSE)
         
sjt.lmer(fit1, fit2, fit3,
         labelPredictors = c("Elder's gender (female)",
                             "Hours of care per week",
                             "Barthel Index",
                             "Educational level (mid)",
                             "Educational level (high)"))}
                  
}
\seealso{
\href{http://strengejacke.de/sjPlot/sjt.lmer/}{sjPlot manual: sjt.lmer} 
           and \code{\link{sjt.lm}} for further examples.
}

