% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotAnova.R
\name{sjp.aov1}
\alias{sjp.aov1}
\title{Plot One-Way-Anova tables}
\usage{
sjp.aov1(depVar, grpVar, meansums = FALSE, type = "dots",
  hideErrorBars = FALSE, title = NULL, axisLabels.y = NULL,
  reverseOrder = FALSE, stringIntercept = "(Intercept)",
  showAxisLabels.y = TRUE, axisTitle.x = "", axisLimits = NULL,
  errorBarColor = NULL, geom.colors = c("#3366a0", "#aa3333"),
  geom.size = 3, breakTitleAt = 50, breakLabelsAt = 25,
  gridBreaksAt = NULL, expand.grid = FALSE, showValueLabels = TRUE,
  labelDigits = 2, showPValueLabels = TRUE, showModelSummary = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{depVar}{dependent variable. Will be used with following formula:
\code{aov(depVar ~ grpVar)}}

\item{grpVar}{grouping variable, as unordered factor. Will be used with following formula:
\code{aov(depVar ~ grpVar)}}

\item{meansums}{logical, if \code{TRUE}, the values reported are the true group mean values (see also \code{\link{sjt.grpmean}}).
If \code{FALSE} (default), the values are reported in the standard way, i.e. the values indicate the difference of
the group mean in relation to the intercept (reference group).}

\item{type}{plot type, whether group means should be plotted as \code{"dots"} (aka forest plots, default)
or as \code{"bars"}}

\item{hideErrorBars}{logical, if \code{TRUE}, the error bars that indicate the confidence intervals of the group means are not
shown. Only applies if argument \code{type} is \code{"bars"}. Default value is \code{FALSE}.}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details). If \code{title = ""},
no title is printed.}

\item{axisLabels.y}{character vector, indicating the value labels of \code{grpVar} that
are used for labelling the axis. See 'Examples'.}

\item{reverseOrder}{logical, if \code{TRUE}, the order of categories (groups) is reversed.
Default is \code{FALSE}.}

\item{stringIntercept}{string that indicates the reference group (intercept), that is appended to
the value label of the grouping variable. Default is \code{"(Intercept)"}.}

\item{showAxisLabels.y}{logical, whether y-axis labels (count values) should be shown or not.}

\item{axisTitle.x}{title for the x-axis. By default, \code{""} is used, i.e. no title
is printed. If \code{axisTitle.x = NULL}, the variable name will be
automatically detected and used as title (see \code{\link[sjmisc]{set_label}})
for details).}

\item{axisLimits}{numeric vector of length 2, defining the range of the plot axis.
By default, the limits range from the lowest confidence interval to the
highest, so plot has maximum zoom.}

\item{errorBarColor}{The color of the error bars that indicate the confidence intervalls
of the group means. Default is \code{NULL}, which means that if \code{type = "dots"},
the \code{pointColor} value will be used as errorbar color. In case \code{type = "bars"},
\code{"black"} will be used as errorbar color.}

\item{geom.colors}{vector of length two, indicating the colors of the points resp.
bars (depending on \code{type}); first value is for groups with positive
means and the second for negative means.}

\item{geom.size}{size of the points resp. bars (depending on \code{type}) that indicate the
mean-value. Default is 3, which is suitable for \code{type = "dots"}. Use something like
0.5 is \code{type = "bars"}.}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{gridBreaksAt}{set breaks for the axis, i.e. at every \code{gridBreaksAt}'th
position a major grid is being printed.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{showValueLabels}{logical, whether the value labels (mean differences) should be plotted
to each dot or not.}

\item{labelDigits}{amount of digits for rounding the estimates (see \code{showValueLabels}).
Default is 2, i.e. estimates have 2 digits after decimal point.}

\item{showPValueLabels}{logical, whether the significance level of each coefficient
should be appended to values or not.}

\item{showModelSummary}{logical, if \code{TRUE}, a summary of the anova model with
         Sum of Squares between groups (ssb), Sum of Squares within groups (ssw), multiple and adjusted
         R-square and F-Test is printed to the lower right corner
         of the diagram. Default is \code{TRUE}.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot One-Way-Anova table sum of squares (SS) of each factor level (group)
               against the dependent variable. The SS of the factor variable against the
               dependent variable (variance within and between groups) is printed to
               the model summary.
}
\examples{
library(sjmisc)
data(efc)
# note: "grpVar" does not need to be a factor.
# coercion to factor is done by the function
sjp.aov1(efc$c12hour, efc$e42dep)


data(efc)
efc.val <- get_labels(efc)
efc.var <- get_label(efc)
sjp.aov1(efc$c12hour,
         as.factor(efc$e42dep),
         axisLabels.y = efc.val['e42dep'],
         axisTitle.x = efc.var[['c12hour']],
         showModelSummary = TRUE)

# -------------------------------------------------
# auto-detection of value labels and variable names
# -------------------------------------------------
sjp.aov1(efc$c12hour,
         efc$e42dep)

# bar-plot, don't use this!
# however, if you dare to, adjust
# 'geom.size'...
sjp.aov1(efc$c12hour,
         efc$c172code,
         axisLabels.y = efc.val['c172code'],
         title = efc.var[['c12hour']],
         type = "bars",
         geom.size = 0.5)
}
\seealso{
\code{\link{sjt.grpmean}}
}

