% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjTabPCA.R
\name{sjt.pca}
\alias{sjt.pca}
\title{Show principal component analysis as HTML table}
\usage{
sjt.pca(data, numberOfFactors = NULL, factorLoadingTolerance = 0.1,
  file = NULL, varlabels = NULL,
  title = "Principal Component Analysis (with varimax rotation)",
  breakLabelsAt = 40, digits = 2, showCronbachsAlpha = TRUE,
  showMSA = FALSE, showVariance = FALSE, alternateRowColors = FALSE,
  stringPov = "Proportion of Variance",
  stringCpov = "Cumulative Proportion", encoding = NULL, CSS = NULL,
  useViewer = TRUE, no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{data}{A data frame with factors (each columns one variable) that should be used
to compute a PCA, or a \code{\link{prcomp}} object.}

\item{numberOfFactors}{A predefined number of factors to use for the calculating the varimax
rotation. By default, this value is \code{NULL} and the amount of factors is
calculated according to the Kaiser-criteria. See paramater \code{plotEigenvalues}.}

\item{factorLoadingTolerance}{Specifies the minimum difference a variable needs to have between
factor loadings (components) in order to indicate a clear loading on just one factor and not
diffusing over all factors. For instance, a variable with 0.8, 0.82 and 0.84 factor loading
on 3 possible factors can not be clearly assigned to just one factor and thus would be removed
from the principal component analysis. By default, the minimum difference of loading values
between the highest and 2nd highest factor should be 0.1}

\item{file}{The destination file, which will be in html-format. If no filepath is specified,
the file will be saved as temporary file and openend either in the RStudio View pane or
in the default web browser.}

\item{varlabels}{The item labels that are printed in the first column. If no item labels are
provided (default), the data frame's column names are used. Item labels must
be a string vector, e.g.: \code{varlabels=c("Var 1", "Var 2", "Var 3")}.}

\item{title}{A table caption. By default, \emph{"Principal Component Analysis (with varimax rotation)"}
is used as the table's title.}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the variable labels are displayed in
one line and when a line break is inserted. Default is 20.}

\item{digits}{The amount of digits used the values inside table cells.
Default is 2.}

\item{showCronbachsAlpha}{If \code{TRUE} (default), the cronbach's alpha value for each factor scale will be calculated,
i.e. all variables with the highest loading for a factor are taken for the
reliability test. The result is an alpha value for each factor dimension.
Only applies when \code{data} is a data frame and no \code{\link{prcomp}} object.}

\item{showMSA}{If \code{TRUE}, shows an additional column with the measure of sampling adequacy according
dor each component.}

\item{showVariance}{If \code{TRUE}, the proportions of variances for each component as well as cumulative
variance are shown in the table footer.}

\item{alternateRowColors}{If \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{stringPov}{The string for the table row that contains the proportions of variances. By default,
\emph{"Proportion of Variance"} will be used.}

\item{stringCpov}{The string for the table row that contains the cumulative variances. By default,
\emph{"Cumulative Proportion"} will be used.}

\item{encoding}{The charset encoding used for variable and value labels. Default is \code{NULL}, so encoding
will be auto-detected depending on your platform (\code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g.) German umlauts).}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{If \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}),
           \item the html-table with inline-css for use with knitr (\code{knitr}),
           \item the \code{factor.index}, i.e. the column index of each variable with the highest factor loading for each factor and
           \item the \code{removed.items}, i.e. which variables have been removed because they were outside of the \code{factorLoadingTolerance}'s range.
           }
           for further use.
}
\description{
Performes a principle component analysis on a data frame or matrix
               (with varimax rotation) and displays the factor solution as HTML
               table, or saves them as file. \cr \cr In case a data frame is used as
               parameter, the Cronbach's Alpha value for each factor scale will be calculated,
               i.e. all variables with the highest loading for a factor are taken for the
               reliability test. The result is an alpha value for each factor dimension.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
       This PCA uses the \code{\link{prcomp}} function and
       the \code{\link{varimax}} rotation.
}
\examples{
\dontrun{
# randomly create data frame with 7 items, each consisting of 4 categories
likert_4 <- data.frame(sample(1:4,
                              500,
                              replace = TRUE,
                              prob = c(0.2, 0.3, 0.1, 0.4)),
                       sample(1:4,
                              500,
                              replace = TRUE,
                              prob = c(0.5, 0.25, 0.15, 0.1)),
                       sample(1:4,
                              500,
                              replace = TRUE,
                              prob = c(0.4, 0.15, 0.25, 0.2)),
                       sample(1:4,
                              500,
                              replace = TRUE,
                              prob = c(0.25, 0.1, 0.4, 0.25)),
                       sample(1:4,
                              500,
                              replace = TRUE,
                              prob = c(0.1, 0.4, 0.4, 0.1)),
                       sample(1:4,
                              500,
                              replace = TRUE),
                       sample(1:4,
                              500,
                              replace = TRUE,
                              prob = c(0.35, 0.25, 0.15, 0.25)))

# Create variable labels
colnames(likert_4) <- c("V1", "V2", "V3", "V4", "V5", "V6", "V7")

# show table
sjt.pca(likert_4)

# -------------------------------
# Data from the EUROFAMCARE sample dataset
# -------------------------------
library(sjmisc)
data(efc)

# retrieve variable and value labels
varlabs <- get_var_labels(efc)

# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")

# create data frame with COPE-index scale
mydf <- as.data.frame(efc[, c(start:end)])
colnames(mydf) <- varlabs[c(start:end)]

sjt.pca(mydf)

# -------------------------------
# auto-detection of labels
# -------------------------------
efc <- set_var_labels(efc, varlabs)
sjt.pca(efc[, c(start:end)])}
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjt.pca/}{sjPlot manual: sjt.pca}
           \item \code{\link{sjp.pca}}
         }
}

