% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjPlotLikert.R
\name{sjp.likert}
\alias{sjp.likert}
\title{Plot likert scales as centered stacked bars}
\usage{
sjp.likert(items, catcount = NULL, cat.neutral = NULL, weightBy = NULL,
  weightByTitleString = NULL, sort.frq = NULL, geom.size = 0.6,
  geom.colors = "BrBG", reverse.colors = FALSE,
  cat.neutral.color = "grey70", intercept.line.color = "grey50",
  value.labels = "show", showPercentageSign = FALSE, legendLabels = NULL,
  hideLegend = FALSE, title = NULL, legendTitle = NULL, includeN = TRUE,
  showItemLabels = TRUE, axisLabels.y = NULL, breakTitleAt = 50,
  breakLabelsAt = 30, breakLegendTitleAt = 30, breakLegendLabelsAt = 28,
  gridRange = 1, gridBreaksAt = 0.2, expand.grid = TRUE,
  axisTitle.x = NULL, axisTitle.y = NULL, coord.flip = TRUE,
  printPlot = TRUE)
}
\arguments{
\item{items}{A data frame with each column representing one likert-item.}

\item{catcount}{the amount of categories of the items (e.g. "strongly disagree",
"disagree", "agree" and "strongly agree" would be \code{catcount=4}).
Note that this parameter only applies to "valid" answers, i.e. if you
have an additional neutral category (see \code{cat.neutral}) like "don't know",
this won't count for \code{catcount} (e.g. "strongly disagree",
"disagree", "agree", "strongly agree" and neutral category "son't know"
would still mean that \code{catcount=4}). \cr
Normally, this parameter can be ignored because the amount of valid categories
is retrieved by the function itself.}

\item{cat.neutral}{If there's a neutral category (like "don't know" etc.), specify
the index number for this category. Else, set \code{cat.neutral=NULL} (default).
The frequencies of neutral categories are plotted as grey bars on the left side of
the figure.}

\item{weightBy}{A weight factor that will be applied to weight all cases from \code{items}.
Must be a vector of same length as \code{nrow(items)}. Default is \code{NULL}, so no weights are used.}

\item{weightByTitleString}{If a weight factor is supplied via the parameter \code{weightBy}, the diagram's title
may indicate this with a remark. Default is \code{NULL}, so the diagram's title will not be modified when
cases are weighted. Use a string as parameter, e.g.: \code{weightByTitleString=" (weighted)"}}

\item{sort.frq}{Indicates whether the items of \code{items} should be ordered by total sum of positive or negative answers.
\itemize{
  \item Use \code{"pos.asc"} to order ascending by sum of positive answers,
  \item \code{"pos.desc"} to order descending by sum of positive answers,
  \item \code{"neg.asc"} for sorting ascending negative answers,
  \item \code{"neg.desc"} for sorting descending negative answers
  \item or \code{NULL} (default) for no sorting.
}}

\item{geom.size}{Width of bars. Recommended values for this parameter are from 0.4 to 1.5}

\item{geom.colors}{User defined color palette for geoms. If specified, must either be vector with color values
of same length as groups defined in \code{legendLabels}, or a specific color palette code (see below).
\itemize{
  \item If not specified, the diverging \code{"GnBu"} color brewer palette will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{geom.colors} is any valid color brewer palette name, the related \href{http://colorbrewer2.org}{color brewer} palette will be used. Use \code{display.brewer.all()} from the \code{RColorBrewer} package to view all available palette names.
}
Else specify your own color values as vector (e.g. \code{geom.colors=c("#f00000", "#00ff00", "#0080ff")}).}

\item{reverse.colors}{If \code{TRUE}, the color scale from \code{geom.colors} will be reversed,
so positive and negative value switch colors.}

\item{cat.neutral.color}{Color of the neutral category, if plotted (see \code{cat.neutral}).}

\item{intercept.line.color}{Color of the vertical intercept line that divides positive and negative values.}

\item{value.labels}{determines style and position of percentage value labels on the bars:
\itemize{
  \item \code{"hide"} hides the value labels, so no percentage values on the bars are printed.
  \item \code{"show"} (default) shows percentage value labels in the middle of each category bar.
  \item \code{"sum.inside"} shows the sums of percentage values for both negative and positive values and prints them inside the end of each bar.
  \item \code{"sum.outide"} shows the sums of percentage values for both negative and positive values and prints them outside the end of each bar.
}}

\item{showPercentageSign}{If \code{TRUE}, percentage signs on value labels are shown.}

\item{legendLabels}{A list or vector of strings that indicate the likert-scale-categories and which
appear as legend text.}

\item{hideLegend}{Indicates whether legend (guide) should be shown or not.}

\item{title}{Title of the diagram, plotted above the whole diagram panel.}

\item{legendTitle}{Title of the diagram's legend.}

\item{includeN}{If \code{TRUE} (default), the N of each item is included into axis labels.}

\item{showItemLabels}{Whether x axis text (category names) should be shown or not}

\item{axisLabels.y}{a character vector with labels for the y-axis (the labels of the
\code{items}). Example: \code{axisLabels.y=c("Q1", "Q2", "Q3")}
Axis labels will automatically be detected, when they have
a \code{"variable.lable"} attribute (see \code{\link{set_var_labels}}) for details).}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{Wordwrap for diagram legend title. Determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{Wordwrap for diagram legend labels. Determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{gridRange}{Sets the limit of the x-axis-range. Default is 1, so the x-scale ranges
from zero to 100 percent on both sides from the center. You can use values beyond 1
(100 percent) in case bar labels are not printed because they exceed the axis range.
E.g. \code{gridRange=1.4} will set the axis from -140 to +140 percent, however, only
(valid) axis labels from -100 to +100 percent are printed. Neutral categories are
adjusted to the most left limit.}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Valid values range from 0 to 1.}

\item{expand.grid}{If \code{TRUE} (default), the diagram has margins, i.e. the y-axis is not exceeded
to the diagram's boundaries.}

\item{axisTitle.x}{A label for the x axis. Useful when plotting histograms with metric scales where no category labels
are assigned to the x axis.}

\item{axisTitle.y}{A label for the y axis. Useful when plotting histograms with metric scales where no category labels
are assigned to the y axis.}

\item{coord.flip}{If \code{TRUE}, the x and y axis are swapped.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df.neg} for the negative values,
          \code{df.pos} for the positive values and \code{df.neutral} for the neutral category values).
}
\description{
Plot likert scales as centered stacked bars.
}
\note{
Note that only even numbers of categories are possible to plot, so the "positive"
       and "negative" values can be splitted into two halfs. A neutral category (like "don't know")
       can be used, but must be indicated by \code{cat.neutral}.
}
\examples{
# prepare data for dichotomous likert scale, 5 items
likert_2 <- data.frame(as.factor(sample(1:2, 500, replace=TRUE, prob=c(0.3,0.7))),
                       as.factor(sample(1:2, 500, replace=TRUE, prob=c(0.6,0.4))),
                       as.factor(sample(1:2, 500, replace=TRUE, prob=c(0.25,0.75))),
                       as.factor(sample(1:2, 500, replace=TRUE, prob=c(0.9,0.1))),
                       as.factor(sample(1:2, 500, replace=TRUE, prob=c(0.35,0.65))))
# create labels
levels_2 <- c("Agree", "Disagree")

# prepare data for 4-category likert scale, with neutral category 5 items
likert_4 <- data.frame(as.factor(sample(1:5, 500, replace=TRUE,
                                        prob=c(0.2,0.3,0.1,0.35,0.05))),
                       as.factor(sample(1:5, 500, replace=TRUE,
                                        prob=c(0.5,0.25,0.15,0.1,0.0))),
                       as.factor(sample(1:5, 500, replace=TRUE,
                                        prob=c(0.25,0.1,0.38,0.24,0.03))),
                       as.factor(sample(1:5, 500, replace=TRUE,
                                        prob=c(0.1,0.32,0.37,0.1,0.11))),
                       as.factor(sample(1:5, 500, replace=TRUE,
                                        prob=c(0.35,0.22,0.15,0.25, 0.03))))
# create labels
levels_4 <- c("Strongly agree",
              "Agree",
              "Disagree",
              "Strongly Disagree",
              "Don't know")

# prepare data for 6-category likert scale, 5 items
likert_6 <- data.frame(
               as.factor(sample(1:6, 500, replace=TRUE, prob=c(0.2,0.1,0.1,0.3,0.2,0.1))),
               as.factor(sample(1:6, 500, replace=TRUE, prob=c(0.15,0.15,0.3,0.1,0.1,0.2))),
               as.factor(sample(1:6, 500, replace=TRUE, prob=c(0.2,0.25,0.05,0.2,0.2,0.2))),
               as.factor(sample(1:6, 500, replace=TRUE, prob=c(0.2,0.1,0.1,0.4,0.1,0.1))),
               as.factor(sample(1:6, 500, replace=TRUE, prob=c(0.1,0.4,0.1,0.3,0.05,0.15))))
# create labels
levels_6 <- c("Very strongly agree", "Strongly agree", "Agree",
              "Disagree", "Strongly disagree", "Very strongly disagree")

# create item labels
items <- c("Q1", "Q2", "Q3", "Q4", "Q5")

# plot dichotomous likert scale, ordered by "negative" values
sjp.likert(likert_2,
           geom.colors = c("green", "red"),
           legendLabels = levels_2,
           axisLabels.y = items,
           sort.frq = "neg.desc")

# plot 4-category-likert-scale, no order
sjp.likert(likert_4,
           cat.neutral = 5,
           legendLabels = levels_4,
           axisLabels.y = items,
           gridRange = 1.2,
           expand.grid = FALSE,
           value.labels = "sum.outside",
           showPercentageSign = TRUE)

# plot 6-category-likert-scale, ordered by positive values,
# in brown color scale
sjp.likert(likert_6,
           legendLabels = levels_6,
           axisLabels.y = items,
           sort.frq = "pos.asc",
           value.labels = "sum.inside")
}
\seealso{
\itemize{
             \item \code{\link{sjp.stackfrq}}
             \item \code{\link{sjt.stackfrq}}
             \item \href{http://www.strengejacke.de/sjPlot/sjp.likert/}{sjPlot manual: sjp.likert}
             }
}

