% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjPlotSetTheme.R
\name{sjp.setTheme}
\alias{sjp.setTheme}
\title{Set global theme options for sjp-functions}
\usage{
sjp.setTheme(title.color = "black", title.size = 1.3,
  title.align = "left", geom.outline.color = NULL,
  geom.outline.size = 0.1, geom.boxoutline.size = 0.5,
  geom.boxoutline.color = "black", geom.alpha = 1, geom.linetype = 1,
  geom.errorbar.size = 0.7, geom.errorbar.linetype = 1,
  geom.label.color = "black", geom.label.size = 4.5, geom.label.alpha = 1,
  geom.label.angle = 0, axis.title.color = "grey30",
  axis.title.size = 1.2, axis.angle.x = 0, axis.angle.y = 0,
  axis.angle = NULL, axis.textcolor.x = "grey30",
  axis.textcolor.y = "grey30", axis.textcolor = NULL,
  axis.linecolor.x = NULL, axis.linecolor.y = NULL, axis.linecolor = NULL,
  axis.line.size = 0.5, axis.textsize.x = 1.1, axis.textsize.y = 1.1,
  axis.textsize = NULL, axis.tickslen = NULL, axis.ticksol = NULL,
  axis.ticksmar = NULL, panel.backcol = NULL, panel.bordercol = NULL,
  panel.col = NULL, panel.major.gridcol = NULL,
  panel.minor.gridcol = NULL, panel.gridcol = NULL, plot.backcol = NULL,
  plot.bordercol = NULL, plot.col = NULL, legend.pos = "right",
  legend.just = NULL, legend.inside = FALSE, legend.size = 1,
  legend.color = "black", legend.title.size = 1,
  legend.title.color = "black", legend.title.face = "bold",
  legend.backgroundcol = "white", legend.bordercol = "white",
  theme = NULL, base = theme_grey())
}
\arguments{
\item{title.color}{Color of the plot title. Default is \code{"black"}.}

\item{title.size}{Size of the plot title. Default is 1.3.}

\item{title.align}{Alignment of plot title. Must be one of \code{"left"} (default),
\code{"center"} or \code{"right"}. You may use initial letter only.}

\item{geom.outline.color}{Color of geom outline. Only applies, if \code{geom.outline.size}
is larger than 0.}

\item{geom.outline.size}{Size of the bar outlines. Default is 0.1. Use
size of \code{0} to remove geom outline.}

\item{geom.boxoutline.size}{Size of outlines and median bar especially for boxplots.
Default is 0.5. Use size of \code{0} to remove boxplot outline.}

\item{geom.boxoutline.color}{Color of outlines and median bar especially for boxplots.
Only applies, if \code{geom.boxoutline.size} is larger than 0.}

\item{geom.alpha}{Specify the transparancy (alpha value) of geoms}

\item{geom.linetype}{Linetype of line geoms. Default is \code{1} (solid line).}

\item{geom.errorbar.size}{Size (thickness) of error bars. Default is \code{0.8}}

\item{geom.errorbar.linetype}{Linetype of error bars. Default is \code{1} (solid line).}

\item{geom.label.color}{Color of geom's value and annotation labels.}

\item{geom.label.size}{Size of geom's value and annotation labels.}

\item{geom.label.alpha}{Alpha level of geom's value and annotation labels.}

\item{geom.label.angle}{Angle of geom's value and annotation labels.}

\item{axis.title.color}{Color of x- and y-axis title labels.}

\item{axis.title.size}{Size of x- and y-axis title labels.}

\item{axis.angle.x}{Angle for x-axis labels.}

\item{axis.angle.y}{Angle for y-axis labels.}

\item{axis.angle}{Angle for x- and y-axis labels. If set, overrides both \code{axis.angle.x} and \code{axis.angle.y}}

\item{axis.textcolor.x}{Color for x-axis labels. If not specified, a default dark gray
color palette will be used for the labels.}

\item{axis.textcolor.y}{Color for y-axis labels. If not specified, a default dark gray
color palette will be used for the labels.}

\item{axis.textcolor}{Color for both x- and y-axis labels.
If set, overrides both \code{axis.textcolor.x} and \code{axis.textcolor.y}}

\item{axis.linecolor.x}{color of x-axis border.}

\item{axis.linecolor.y}{color of y-axis border.}

\item{axis.linecolor}{Color for both x- and y-axis borders.
If set, overrides both \code{axis.linecolor.x} and \code{axis.linecolor.y}.}

\item{axis.line.size}{Size (thickness) of axis lines. Only affected, if \code{axis.linecolor}
is set.}

\item{axis.textsize.x}{Size of x-axis labels.}

\item{axis.textsize.y}{Size of y-axis labels.}

\item{axis.textsize}{Size for both x- and y-axis labels.
If set, overrides both \code{axis.textsize.x} and \code{axis.textsize.y}.}

\item{axis.tickslen}{Length of axis tick marks}

\item{axis.ticksol}{Color of axis tick marks.}

\item{axis.ticksmar}{Margin between axis labels and tick marks.}

\item{panel.backcol}{Color of the diagram's background.}

\item{panel.bordercol}{Color of whole diagram border (panel border).}

\item{panel.col}{Color of both diagram's border and background.
If set, overrides both \code{panel.bordercol} and \code{panel.backcol}.}

\item{panel.major.gridcol}{Color of the major grid lines of the diagram background.}

\item{panel.minor.gridcol}{Color of the minor grid lines of the diagram background.}

\item{panel.gridcol}{Color for both minor and major grid lines of the diagram background.
If set, overrides both \code{panel.major.gridcol} and \code{panel.minor.gridcol}.}

\item{plot.backcol}{Color of the plot's background.}

\item{plot.bordercol}{Color of whole plot's border (panel border).}

\item{plot.col}{Color of both plot's region border and background.
If set, overrides both \code{plot.backcol} and \code{plot.bordercol}.}

\item{legend.pos}{Position of the legend, if a legend is drawn. \cr
\emph{legend outside plot} \cr
Use \code{"bottom"}, \code{"top"}, \code{"left"}
or \code{"right"} to position the legend above, below, on the left or right side of the diagram.
Right positioning is default. \cr
\emph{legend inside plot} \cr
If \code{legend.inside} is \code{TRUE}, legend can be placed inside
plot. Use \code{"top left"}, \code{"top right"}, \code{"bottom left"} and \code{"bottom right"}
to position legend in any of these corners, or a two-element numeric vector with values from 0-1.}

\item{legend.just}{Justification of legend, relative to its position ("center" or
two-element numeric vector with values from 0-1. By default (outside legend),
justification is centered. If legend is inside and justification not specified,
legend justification is set according to legend position.}

\item{legend.inside}{Logical, use \code{TRUE} to put legend inside the plotting area. See \code{legend.pos}.}

\item{legend.size}{Text size of the legend. Default is 1. Relative size, so recommended values are from 0.3 to
2.5}

\item{legend.color}{Color of the legend labels.}

\item{legend.title.size}{Text size of the legend title.}

\item{legend.title.color}{Color of the legend title.}

\item{legend.title.face}{Font face of the legend title. By default, \code{"bold"} face is used.}

\item{legend.backgroundcol}{Fill color of the legend's background. Default is \code{"white"}, so no visible background is drawn.}

\item{legend.bordercol}{Color of the legend's border. Default is \code{"white"}, so no visible border is drawn.}

\item{theme}{valid parameter for ggplot default-themes are:
\itemize{
  \item \code{theme_bw}
  \item \code{theme_classic}
  \item \code{theme_grey}
  \item \code{theme_light}
  \item \code{theme_linedraw}
  \item \code{theme_minimal}
}
Furthermore, there are some theme-presets, which can be used:
\itemize{
  \item \code{"blank"}: a theme with no grids and axes.
  \item \code{"538"}: a theme inspired by \href{http://fivethirtyeight.com}{538-charts}, adapted from \href{http://minimaxir.com/2015/02/ggplot-tutorial/}{minimaxir.com}.
  \item \code{"forest"}: a theme for forest plots, with no grids.
}}

\item{base}{Base theme where theme is built on. By default, all
         metrics from \code{theme_gray()} are used.}
}
\value{
The customized theme object, or \code{NULL}, if a ggplot-theme
          was used.
}
\description{
Set global theme options for sjp-functions.
}
\examples{
\dontrun{
data(efc)
# set sjPlot-defaults, a slightly modification
# of the ggplot base theme
sjp.setTheme()

# legends of all plots inside
sjp.setTheme(legend.pos = "top left",
             legend.inside = TRUE)
sjp.xtab(efc$e42dep,
         efc$e16sex,
         showTableSummary = FALSE)

# Use classic-theme as base. you may need to
# load the ggplot2-library.
library(ggplot2)
sjp.setTheme(base = theme_classic())
sjp.frq(efc$e42dep)

# adjust value labels
sjp.setTheme(geom.label.size = 3.5,
             geom.label.color = "#3366cc",
             geom.label.angle = 90)
# hjust-aes needs adjustment for this
update_geom_defaults('text', list(hjust = -0.1))
sjp.xtab(efc$e42dep,
         efc$e16sex,
         showTableSummary = FALSE,
         labelPos = "center")

# Create own theme based on classic-theme
sjp.setTheme(base = theme_classic(),
             axis.linecolor = "grey50",
             axis.textcolor = "#6699cc")
sjp.frq(efc$e42dep)

# use theme pre-set, taken from tutorial
# http://minimaxir.com/2015/02/ggplot-tutorial/
sjp.setTheme(theme = "538",
             geom.alpha = 0.8)
library(ggplot2) # for custom base-line
sjp.frq(efc$e42dep,
        geom.color = "#c0392b",
        expand.grid = TRUE,
        printPlot = FALSE)$plot +
  geom_hline(yintercept = 0,
             size = 0.5,
             colour = "black")}
}
\references{
\itemize{
             \item \href{http://zevross.com/blog/2014/08/04/beautiful-plotting-in-r-a-ggplot2-cheatsheet-3/}{Beautiful plotting in R: A ggplot2 cheatsheet}
             \item \href{http://minimaxir.com/2015/02/ggplot-tutorial/}{An Introduction on How to Make Beautiful Charts With R and ggplot2}
            }
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/custplot/}{sjPlot manual: customize plot appearance}
         }
}

