% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjPlotInteractions.R
\name{sjp.int}
\alias{sjp.int}
\title{Plot interaction effects of (generalized) linear (mixed) models}
\usage{
sjp.int(fit, diff = FALSE, moderatorValues = "minmax",
  swapPredictors = FALSE, plevel = 0.05, title = NULL,
  fillColor = "grey", fillAlpha = 0.4, geom.colors = "Set1",
  axisTitle.x = NULL, axisTitle.y = NULL, legendLabels = NULL,
  showValueLabels = FALSE, breakTitleAt = 50, breakLegendLabelsAt = 20,
  breakAnnotationLabelsAt = 50, axisLimits.y = NULL, gridBreaksAt = NULL,
  showInterceptLines = FALSE, showInterceptLabels = TRUE,
  interceptLineColor = "darkseagreen4", estLineColor = "darkslategray4",
  lineLabelSize = 3.7, lineLabelColor = "black",
  lineLabelString = "(no interaction)", printPlot = TRUE)
}
\arguments{
\item{fit}{the fitted (generalized) linear (mixed) model object, including interaction terms. Accepted model
classes are
\itemize{
  \item linear models (\code{lm})
  \item generalized linear models (\code{glm})
  \item linear mixed effects models (\code{lme4::lmer})
  \item generalized linear mixed effects models (\code{lme4::glmer})
  }}

\item{diff}{if \code{FALSE} (default), the minimum and maximum interaction effects of predictor 2 on predictor 1
are shown (one line each). if \code{TRUE}, only the difference between minimum and maximum interaction effect
is shown (single line)}

\item{moderatorValues}{indicates which values of the moderator variable should be used when plotting the effects of the
independent variable on the dependent variable. By default, \code{"minmax"} is used, i.e. the minimum and maximum values
(lower and upper bounds) of the moderator are used to plot the interaction between independent variable and moderator.
Use \code{"meansd"} to use the mean value of the moderator as well as one standard deviation below and above mean value
to plot the effect of the moderator on the independent variable (following
the convention suggested by Cohen and Cohen and popularized by Aiken and West,
i.e. using the mean, the value one standard deviation above, and the value one standard deviation below the mean
as values of the moderator, see \href{http://www.theanalysisfactor.com/3-tips-interpreting-moderation/}{Grace-Martin K: 3 Tips to Make Interpreting Moderation Effects Easier}).}

\item{swapPredictors}{if \code{TRUE}, the predictor with less unique values is printed along the x-axis. Default is
\code{FALSE}, so the predictor with more unique values is printed along the x-axis.}

\item{plevel}{Indicates at which p-value an interaction term is considered as significant. Default is
0.05 (5 percent).}

\item{title}{a default title used for the plots. Default value is \code{NULL}, which means that each plot's title
includes the dependent variable as well as the names of the interaction terms.}

\item{fillColor}{fill color of the shaded area between the minimum and maximum lines. Default is \code{"grey"}.
Either set \code{fillColor} to \code{NULL} or use 0 for \code{fillAlpha} if you want to hide the shaded area.}

\item{fillAlpha}{alpha value (transparancy) of the shaded area between the minimum and maximum lines. Default is 0.4.
Use either 0 or set \code{fillColor} to \code{NULL} if you want to hide the shaded area.}

\item{geom.colors}{A vector of color values. First value is the color of the line indicating the lower bound of
the interaction term (moderator value). Second value is the color of the line indicating the upper bound of
the interaction term (moderator value). Third value, if applicable, is the color of the line indicating the
mean value of the interaction term (moderator value). Third value is only used when \code{moderatorValues}
is \code{"meansd"}. Or, if \code{diff} is \code{TRUE}, only one color value for the line indicating the
upper difference between lower and upper bound of interaction terms.}

\item{axisTitle.x}{a default title used for the x-axis. Default value is \code{NULL},
which means that each plot's x-axis uses the predictor's name as title.}

\item{axisTitle.y}{a default title used for the y-axis. Default value is \code{NULL},
which means that each plot's y-axis uses the dependent variable's name as title.}

\item{legendLabels}{Labels for the guide/legend. Default is \code{NULL}, so the name of the predictor with
min/max-effect is used as legend label.}

\item{showValueLabels}{if \code{TRUE}, value labels are plotted along the lines. Default is \code{FALSE}.}

\item{breakTitleAt}{Wordwrap for diagram's title. Determines how many chars of the title are
displayed in one line and when a line break is inserted. Default is \code{50}.}

\item{breakLegendLabelsAt}{Wordwrap for diagram legend labels. Determines how many chars of the legend labels are
displayed in one line and when a line break is inserted. Default is \code{20}.}

\item{breakAnnotationLabelsAt}{Wordwrap for diagram annotation labels. Determines how many chars of the legend labels are
displayed in one line and when a line break is inserted. Default is \code{50}.
Only applies if \code{showInterceptLine} is \code{TRUE}.}

\item{axisLimits.y}{A vector with two values, defining the lower and upper limit from the y-axis.
By default, this value is \code{NULL}, i.e. axis limits will be calculated upon the
range of y-values.}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Default is \code{NULL}.}

\item{showInterceptLines}{If \code{TRUE}, the intercept and the estimate of the predictor
(reference category of predictor in case interaction is not present) are plotted.}

\item{showInterceptLabels}{If \code{TRUE} (default), the intercept lines are labelled. Only
applies if \code{showInterceptLines} is \code{TRUE}.}

\item{interceptLineColor}{The line color of the model's intercept line. Only applies, if
\code{showInterceptLines} is \code{TRUE}.}

\item{estLineColor}{The line color of the model's predictor's estimate line. Only applies, if
\code{showInterceptLines} is \code{TRUE}.}

\item{lineLabelSize}{The size of the intercept line annotations inside the plot. Only applies
if \code{showInterceptLines} is \code{TRUE}. Default is 3.7.}

\item{lineLabelColor}{The color of the intercept line annotations inside the plot. Only applies
if \code{showInterceptLines} is \code{TRUE}. Default is \code{"black"}.}

\item{lineLabelString}{Default string for the intercept lines that is appended to the predictor
variable name. By default, this string is \code{"(no interaction)"}.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-objects with the complete plot-list (\code{plot.list})
          as well as the data frame that were used for setting up the ggplot-objects (\code{df.list}).
}
\description{
Plot regression (predicted values) or probability lines (predicted probabilities) of
               significant interaction terms to better understand effects
               of moderations in regression models. This function accepts following fitted model classes:
               \itemize{
                 \item linear models (\code{lm})
                 \item generalized linear models (\code{glm})
                 \item linear mixed effects models (\code{lme4::lmer})
                 \item generalized linear mixed effects models (\code{lme4::glmer})
               }
               Note that beside interaction terms, also the single predictors of each interaction (main effects)
               must be included in the fitted model as well. Thus, \code{lm(dep ~ pred1 * pred2)} will work,
               but \code{lm(dep ~ pred1:pred2)} won't!
}
\note{
Note that beside interaction terms, also the single predictors of each interaction (main effects)
       must be included in the fitted model as well. Thus, \code{lm(dep ~ pred1 * pred2)} will work,
       but \code{lm(dep ~ pred1:pred2)} won't!
}
\examples{
# Note that the data sets used in this example may not be perfectly suitable for
# fitting linear models. I just used them because they are part of the R-software.

# fit "dummy" model.
fit <- lm(weight ~ Time * Diet,
          data = ChickWeight,
          x = TRUE)

# show summary to see significant interactions
summary(fit)

# plot regression line of interaction terms
sjp.int(fit)
# plot regression line of interaction terms, including value labels
sjp.int(fit, showValueLabels = TRUE)


# load sample data set
data(efc)
# create data frame with variables that should be included
# in the model
mydf <- data.frame(usage = efc$tot_sc_e,
                   sex = efc$c161sex,
                   education = efc$c172code,
                   burden = efc$neg_c_7,
                   dependency = efc$e42dep)
# convert gender predictor to factor
mydf$sex <- relevel(factor(mydf$sex), ref = "2")
# fit "dummy" model
fit <- lm(usage ~ .*., data = mydf, x = TRUE)
summary(fit)

# plot interactions
sjp.int(fit)

# plot interactions, using mean and sd as moderator
# values to calculate interaction effect
sjp.int(fit, moderatorValues = "meansd")

# plot interactions, including those with p-value up to 0.1
sjp.int(fit,
        plevel = 0.1,
        showInterceptLines = TRUE)

# -------------------------------
# Predictors for negative impact of care.
# Data from the EUROFAMCARE sample dataset
# -------------------------------
data(efc)
# create binary response
y <- ifelse(efc$neg_c_7 < median(na.omit(efc$neg_c_7)), 0, 1)
# create data frame for fitted model
mydf <- data.frame(y = as.factor(y),
                   sex = as.factor(efc$c161sex),
                   barthel = as.numeric(efc$barthtot))
# fit model
fit <- glm(y ~ sex * barthel,
           data = mydf,
           family = binomial(link = "logit"),
           x = TRUE)
# plot interaction, increase p-level sensivity
sjp.int(fit,
        legendLabels = sji.getValueLabels(efc$c161sex),
        plevel = 0.1)

# compare results to boxplots
sjp.grpfrq(mydf$barthel,
           mydf$y,
           interactionVar = mydf$sex,
           interactionVarLabels = sji.getValueLabels(efc$c161sex),
           legendLabels = c("low burden", "high burden"),
           type = "box")
}
\references{
\itemize{
             \item \href{http://www.theanalysisfactor.com/interpreting-interactions-in-regression/}{Grace-Martin K: Interpreting Interactions in Regression}
             \item \href{http://www.theanalysisfactor.com/clarifications-on-interpreting-interactions-in-regression/}{Grace-Martin K: Clarifications on Interpreting Interactions in Regression}
             \item \href{http://www.theanalysisfactor.com/3-tips-interpreting-moderation/}{Grace-Martin K: 3 Tips to Make Interpreting Moderation Effects Easier}
             \item Aiken and West (1991). Multiple Regression: Testing and Interpreting Interactions.
             }
}
\seealso{
\itemize{
           \item \code{\link{sjp.emm.int}}
           }
}

