% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.class_cube}
\alias{plot.class_cube}
\title{Plot classified images}
\usage{
\method{plot}{class_cube}(
  x,
  y,
  ...,
  tile = x$tile[[1]],
  title = "Classified Image",
  legend = NULL,
  palette = "Spectral",
  tmap_options = NULL
)
}
\arguments{
\item{x}{Object of class "class_cube".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{title}{Title of the plot.}

\item{legend}{Named vector that associates labels to colors.}

\item{palette}{Alternative RColorBrewer palette}

\item{tmap_options}{List with optional tmap parameters
tmap_max_cells (default: 1e+06)
tmap_graticules_labels_size (default: 0.7)
tmap_legend_title_size (default: 1.5)
tmap_legend_text_size (default: 1.2)
tmap_legend_bg_color (default: "white")
tmap_legend_bg_alpha (default: 0.5)}
}
\value{
A  color map, where each pixel has the color
                        associated to a label, as defined by the legend
                        parameter.
}
\description{
plots a classified raster using ggplot.
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # label cube with the most likely class
    label_cube <- sits_label_classification(
        probs_cube, output_dir = tempdir()
    )
    # plot the resulting classified image
    plot(label_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
