% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_factory.R
\name{.sits_function_factory}
\alias{.sits_function_factory}
\alias{.sits_factory_function}
\title{Create a closure for calling functions with and without data}
\usage{
.sits_factory_function(data, fun)
}
\arguments{
\item{data}{Tibble with time series data and metadata.}

\item{fun}{Function that performs calculation on the input data.}
}
\value{
A closure that encapsulates the function applied to data.
}
\description{
This internal function implements the factory method pattern.
Its creates a generic interface to closures in R so that the functions
in the sits package can be called in two different ways:
1. Called directly, passing input data and parameters.
2. Called as second-order values (parameters of another function).
   In the second case, the call will pass no data values
   and only pass the parameters for execution

The factory pattern is used in many situations in the sits package,
to allow different alternatives
for filtering, pattern creation, training, and cross-validation
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
