% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{run_method}
\alias{run_method}
\title{Run one or more methods on simulated data.}
\usage{
run_method(object, methods, out_loc = "out", parallel = NULL)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{DrawsRef}} (or a list of
such objects) as returned by \code{link{simulate_from_model}}. If
\code{object} is a \code{\linkS4class{Simulation}}, then function is applied
 to the referenced draws in that simulation and returns the same
\code{Simulation} object but with references added to the new outputs
created.}

\item{methods}{a list of \code{\linkS4class{Method}} and/or
\code{\linkS4class{ExtendedMethod}} objects or a single \code{\linkS4class{Method}}
or object \code{\linkS4class{ExtendedMethod}}}

\item{out_loc}{(optional) a length-1 character vector that gives location
(relative to model's path) that method outputs are stored.This can be
useful for staying organized when multiple simulations are based on
the same Model and Draws objects.}

\item{parallel}{either \code{NULL} or a list containing \code{socket_names}
and (optionally) \code{libraries} and \code{save_locally}
(see Details for more information)}
}
\description{
Given a \code{\linkS4class{Method}} object or list of \code{\linkS4class{Method}} objects,
this function runs the method(s) on the draws passed through \code{object}.
The output of each method is saved to file.
}
\details{
This function creates objects of class \code{\linkS4class{Output}} and saves each to
file (at dir/model_name/<out_loc>/r<index>_<method_name>.Rdata. If parallel
is not NULL, then it must be a list containing \code{socket_names}, which can
either be a positive integer specifying the number of copies to run on
localhost or else a character vector of machine names (e.g.,
"mycluster-0-0").  The list \code{parallel} can also contain
\code{libraries}, a character vector of R packages that will be needed on the
slaves and \code{save_locally}, a logical that indicates whether the files
generated should be saved on the slaves (i.e., locally) or on the master.

Before running each method on index i, the RNG state is restored to what it
was at the end of calling \code{\link{simulate_from_model}} on this index.
This is only relevant for randomized methods.  The choice to do this ensures
that one will get identical results regardless of the order in which methods
and indices are run in.  When \code{\linkS4class{ExtendedMethod}} objects are
passed, these are run after all \code{Method} objects have been run.  This is
because each \code{ExtendedMethod} object depends on the output of its base
method.  Furthermore, before an \code{ExtendedMethod} is called, the RNG
state is restored to what it was after the base method had been called.
}
\examples{
\dontrun{
 # suppose previously we had run the following:
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model, n = 20) \%>\%
   simulate_from_model(nsim = 50, index = 1:3)
 # then we could add
 sim <- run_method(sim, my_example_method)
 }
}
\seealso{
\code{\link{generate_model}} \code{\link{simulate_from_model}}
}

