% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trtAssign.R
\name{trtAssign}
\alias{trtAssign}
\title{Assign treatment}
\usage{
trtAssign(dtName, nTrt = 2, balanced = TRUE, strata = NULL,
  grpName = "trtGrp")
}
\arguments{
\item{dtName}{data table}

\item{nTrt}{number of treatment groups}

\item{balanced}{indicator for treatment assignment process}

\item{strata}{vector of strings representing stratifying variables}

\item{grpName}{string representing variable name for treatment or
exposure group}
}
\value{
An integer (group) ranging from 1 to length of the
probability vector
}
\description{
Assign treatment
}
\examples{
dt <- genData(15)

dt1 <- trtAssign(dt, nTrt = 3, balanced = TRUE)
dt1[, .N, keyby = trtGrp]

dt2 <- trtAssign(dt, nTrt = 3, balanced = FALSE)
dt2[, .N, keyby = trtGrp]

def <- defData(varname = "male", formula = .4, dist = "binary")
dt <- genData(1000, def)
dt

dt3 <- trtAssign(dt, nTrt = 5, strata = "male", balanced = TRUE, grpName = "Group")
dt3
dt3[, .N, keyby = .(male, Group)]
dt3[, .N, keyby = .(Group)]

dt4 <- trtAssign(dt, nTrt = 5, strata = "male", balanced = FALSE, grpName = "Group")
dt4[, .N, keyby = .(male, Group)]
dt4[, .N, keyby = .(Group)]

dt5 <- trtAssign(dt, nTrt = 5, balanced = TRUE, grpName = "Group")
dt5[, .N, keyby = .(male, Group)]
dt5[, .N, keyby = .(Group)]

}
\seealso{
\code{\link{trtObserve}}
}
