% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sim_standardized_matrices}
\alias{sim_standardized_matrices}
\title{Return model characteristics}
\usage{
sim_standardized_matrices(m, max_iterations = 100)
}
\arguments{
\item{m}{Structural model represented by lavaan Syntax}

\item{max_iterations}{Maximum number of iterations before the algorithm fails}
}
\value{
list of path and covariance coefficients
}
\description{
Function that takes a lavaan model with standardized parameters returns a list with model caracteristics
}
\details{
This function supports the `~` operator for regressions, the `~~` for covariances (but not variances), and the `=~` latent variable loadings. It does not support intercepts (e.g,. `y ~ 1`), thresholds, scaling factors, formative factors, or equality constraints.
}
\examples{
# lavaan model
m = "Latent_1 =~ 0.8 * Ob_1 + 0.8 * Ob_2"

sim_standardized_matrices(m)
}
