% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_sf.R
\name{gg_sf_col}
\alias{gg_sf_col}
\title{Simple feature ggplot map that is coloured.}
\usage{
gg_sf_col(data, col_var, text_var = NULL, pal = NULL,
  pal_na = "#7F7F7F", pal_rev = FALSE, size_point = 1,
  size_line = 0.5, alpha = NULL, borders = NULL,
  borders_behind = TRUE, pal_borders = "#7F7F7F", borders_size = 0.2,
  title = NULL, title_wrap = 80, subtitle = NULL,
  subtitle_wrap = 80, col_cuts = NULL, col_labels = NULL,
  col_na = TRUE, col_pretty_n = 5, col_method = NULL,
  col_right_closed = TRUE, col_title = NULL, col_title_wrap = 25,
  caption = NULL, caption_wrap = 80, font_family = "",
  font_size_title = NULL, font_size_body = NULL, mobile = FALSE)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{col_var}{Unquoted variable for points to be coloured by. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the colorbrewer Set1 or viridis.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{size_point}{Size of points. Defaults to 0.5.}

\item{size_line}{Size of lines. Defaults to 0.5.}

\item{alpha}{The opacity of features. Defaults to 1 for points/lines, or 0.95 for polygons.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_behind}{TRUE or FALSE  as to whether the borders is to be behind the sf object defined in the data argument. Defaults to TRUE.}

\item{pal_borders}{Colour of the borders. Defaults to "#7F7F7F".}

\item{borders_size}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_labels}{A function or named vector to modify colour scale labels. Defaults to stringr::str_to_sentence for categorical colour variables and scales::comma for numeric colour variables. Use ggplot2::waiver() to keep colour labels untransformed.}

\item{col_na}{TRUE or FALSE of whether to include col_var NA values. Defaults to TRUE.}

\item{col_pretty_n}{For a numeric colour variable of "bin" col_method, the desired number of intervals on the colour scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." If numeric, defaults to "bin".}

\item{col_right_closed}{For a numeric colour variable, TRUE or FALSE of whether bins or quantiles are to be cut right-closed. Defaults to TRUE.}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where mobile equals TRUE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{font_family}{Font family to use. Defaults to "".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within a shiny app with the mobileDetect function, then use mobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is coloured, but not facetted.
}
\examples{
gg_sf_col(example_sf_point, 
          col_var = trend_category, 
          borders = nz)
   
gg_sf_col(example_sf_polygon, 
          col_var = density, 
          borders = nz, 
          col_method = "bin", 
          col_cuts = c(0, 10, 50, 100, 150, 200, Inf))

gg_sf_col(example_sf_polygon, 
          col_var = density, 
          borders = nz, 
          col_method = "quantile", 
          col_cuts = c(0, 0.25, 0.5, 0.75, 0.95, 1))
          
}
