% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrier_batch.R
\name{calculate_barrier_3d_batch}
\alias{calculate_barrier_3d_batch}
\title{Calculate barrier from a 3D landscape with multiple simulations}
\usage{
calculate_barrier_3d_batch(
  l,
  bg = NULL,
  start_location_value = c(0, 0),
  start_r = 0.1,
  end_location_value = c(0.7, 0.6),
  end_r = 0.15,
  Umax,
  expand = TRUE,
  omit_unstable = FALSE,
  base = exp(1)
)
}
\arguments{
\item{l}{A \code{3d_animation_landscape} or a \code{3d_matrix_landscape}.}

\item{bg}{A \code{barrier_grid_3d} object if you want to use different parameters for each condition. Otherwise \code{NULL}.}

\item{start_location_value, end_location_value}{The initial position (in value) for searching the start/end point.}

\item{start_r, end_r}{The searching (L1) radius for searching the start/end point.}

\item{Umax}{The highest possible value of the potential function.}

\item{expand}{If the values in the range all equal to \code{Umax}, expand the range or not?}

\item{omit_unstable}{If a state is not stable (the "local minimum" overlaps with the saddle point), omit that state or not?}

\item{base}{The base of the log function.}
}
\description{
Calculate barrier from a 3D landscape with multiple simulations
}
