% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_get_shares.R
\name{sfa_get_shares_}
\alias{sfa_get_shares_}
\title{Get basic company information}
\usage{
sfa_get_shares_(Ticker, type, period, fyear, start, end, api_key, cache_dir)
}
\arguments{
\item{Ticker}{\link{integer} Ticker of the companies of interest.}

\item{type}{\link{character} Filter for fiscal year. Only works with \code{type = "wa-basic"} and \code{type = "wa-diluted"}. As SimFin+ user, this filter can be
omitted to retrieve all shares outstanding available for the company. You
can also chain this filter with a comma, to retrieve multiple years at once
(e.g. \code{fyear = "2015,2016,2017"} to retrieve the data for 3 years at once).}

\item{period}{\link{character} Filter for periods. Only works with \code{type = "wa-basic"} and \code{type = "wa-diluted"}. This filter can be omitted to
retrieve all shares outstanding available for the company. You can also
chain this filter with a comma (e.g. \code{period = "quarters,fy"} to retrieve
all quarters and the full financial year figures).
\itemize{
\item \code{"q1"}: First fiscal quarter.
\item \code{"q2"}: Second fiscal quarter.
\item \code{"q3"}: Third fiscal quarter.
\item \code{"q4"}: Fourth fiscal quarter.
\item \code{"fy"}: Full fiscal year.
\item \code{"h1"}: First 6 months of fiscal year.
\item \code{"h2"}: Last 6 months of fiscal year.
\item \code{"9m"}: First nine months of fiscal year.
\item \code{"6m"}: Any fiscal 6 month period (first + second half years).
\item \code{"quarters"}: All quarters (q1 + q2 + q3 + q4).
}}

\item{fyear}{\link{integer} Filter for fiscal year. As a non-SimFin+ user, you
have to provide exactly one fiscal year. As SimFin+ user, this filter can
be omitted to retrieve all statements available for the company.}

\item{start}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending AFTER the specified
date.}

\item{end}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending BEFORE the specified
date.}

\item{api_key}{\link{character} Your 'SimFin' API key. It's recommended to set
the API key globally using \link{sfa_set_api_key}.}

\item{cache_dir}{\link{character} Your cache directory. It's recommended to set
the cache directory globally using \link{sfa_set_cache_dir}.}
}
\description{
Get basic company information
}
