% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_from_pedigree.R
\name{sim_from_pedigree}
\alias{sim_from_pedigree}
\title{Simulate genotypes for pedigree}
\usage{
sim_from_pedigree(
  pedigree,
  L = 100,
  xchr = FALSE,
  m = 10,
  p = 0,
  obligate_chiasma = FALSE
)
}
\arguments{
\item{pedigree}{Matrix or data frame describing a pedigree, with first four
columns being individual ID, mom ID, dad ID, and sex (female as
\code{0}, male as \code{1}).}

\item{L}{Length of chromosome in cM (or a vector of chromosome lengths)}

\item{xchr}{If TRUE, simulate X chromosome. (If \code{L} is a
vector, this should be a vector of TRUE/FALSE values, of the same
length as \code{L}, or a character string with the name of the X
chromosome, in \code{L}.)}

\item{m}{Crossover interference parameter, for chi-square model
(m=0 corresponds to no interference).}

\item{p}{proportion of crossovers coming from no-interference process}

\item{obligate_chiasma}{If TRUE, require an obligate chiasma on the
4-strand bundle at meiosis.}
}
\value{
A list with each component being the data for one
individual, as produced by the \code{\link[=cross]{cross()}} function.  Those
results are a list with two components, corresponding to the
maternal and paternal chromosomes. The chromosomes are represented
as lists with two components: an integer vector of alleles in
chromosome intervals, and a numeric vector of locations of the
right-endpoints of those intervals; these two vectors should have
the same length.

If the input \code{L} is a vector, in order to simulate multiple
chromosomes at once, then the output will be a list with length
\code{length(L)}, each component being a chromosome and having the
form described above.
}
\description{
Simulate genotypes along one chromosome for a pedigree
}
\examples{
# simulate AIL pedigree
tab <- sim_ail_pedigree(12, 30)
# simulate data from that pedigree
dat <- sim_from_pedigree(tab)
# simulate multiple chromosomes
dat <- sim_from_pedigree(tab, c("1"=100, "2"=75, "X"=100), xchr="X")
}
\seealso{
\code{\link[=check_pedigree]{check_pedigree()}},
\code{\link[=sim_ril_pedigree]{sim_ril_pedigree()}}, \code{\link[=sim_ail_pedigree]{sim_ail_pedigree()}},
\code{\link[=sim_ril_pedigree]{sim_ril_pedigree()}}
}
\keyword{datagen}
