% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_meiosis.R
\name{cross}
\alias{cross}
\title{Cross two individuals}
\usage{
cross(
  mom,
  dad,
  m = 10,
  p = 0,
  xchr = FALSE,
  male = FALSE,
  obligate_chiasma = FALSE,
  Lstar = NULL
)
}
\arguments{
\item{mom}{An individual object, as produced by
\code{\link[=create_parent]{create_parent()}} or this function.}

\item{dad}{An individual object, as produced by
\code{\link[=create_parent]{create_parent()}} or this function.}

\item{m}{interference parameter for chi-square model}

\item{p}{proportion of crossovers coming from no-interference process}

\item{xchr}{If TRUE, simulate X chromosome}

\item{male}{If TRUE, simulate a male (matters only if
\code{xchr=TRUE})}

\item{obligate_chiasma}{If TRUE, require an obligate chiasma on the
4-strand bundle at meiosis.}

\item{Lstar}{Adjusted chromosome length, if
\code{obligate_chiasma=TRUE}. Calculated if not provided.}
}
\value{
A list with two components, for the individual's two
chromosomes.  Each is a list with alleles in chromosome intervals
(as integers) and locations of the right endpoints of those
intervals.
}
\description{
Simulate the cross of two individuals to create a
single progeny
}
\details{
Simulations are under the Stahl model with the
interference parameter being an integer. This is an extension of
the chi-square model, but with chiasmata being the superposition of
two processes, one following the chi-square model and the other
exhibiting no interference.
}
\examples{
mom <- create_parent(100, 1:2)
dad <- create_parent(100, 1:2)
child <- cross(mom, dad)
}
\seealso{
\code{\link[=create_parent]{create_parent()}}, \code{\link[=sim_meiosis]{sim_meiosis()}},
\code{\link[=sim_crossovers]{sim_crossovers()}}, \code{\link[=calc_Lstar]{calc_Lstar()}}
}
\keyword{datagen}
