% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LinSDE2SSM}
\alias{LinSDE2SSM}
\title{Convert Parameters from the Linear Stochastic Differential Equation Model
to State Space Model Parameterization}
\usage{
LinSDE2SSM(iota, phi, sigma_l, delta_t)
}
\arguments{
\item{iota}{Numeric vector.
An unobserved term that is constant over time
(\eqn{\boldsymbol{\iota}}).}

\item{phi}{Numeric matrix.
The drift matrix
which represents the rate of change of the solution
in the absence of any random fluctuations
(\eqn{\boldsymbol{\Phi}}).}

\item{sigma_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(sigma))})
of the covariance matrix of volatility
or randomness in the process
(\eqn{\boldsymbol{\Sigma}}).}

\item{delta_t}{Numeric.
Time interval
(\eqn{\Delta_t}).}
}
\value{
Returns a list of state space parameters:
\itemize{
\item \code{alpha}: Numeric vector.
Vector of constant values for the dynamic model
(\eqn{\boldsymbol{\alpha}}).
\item \code{beta}: Numeric matrix.
Transition matrix relating the values of the latent variables
from the previous time point to the current time point.
(\eqn{\boldsymbol{\beta}}).
\item \code{psi_l}: Numeric matrix.
Cholesky factorization (\code{t(chol(psi))})
of the process noise covariance matrix
\eqn{\boldsymbol{\Psi}}.
}
}
\description{
This function converts parameters from
the linear stochastic differential equation model
to state space model parameterization.
}
\details{
Let the linear stochastic equation model be given by
\deqn{
    \mathrm{d}
    \boldsymbol{\eta}_{i, t}
    =
    \left(
      \boldsymbol{\iota}
      +
      \boldsymbol{\Phi}
      \boldsymbol{\eta}_{i, t}
    \right)
    \mathrm{d} t
    +
    \boldsymbol{\Sigma}^{\frac{1}{2}}
    \mathrm{d}
    \mathbf{W}_{i, t}
  }
for individual \eqn{i} and time \eqn{t}.
The discrete-time state space model
given below
represents the discrete-time solution
for the linear stochastic differential equation.
\deqn{
    \boldsymbol{\eta}_{i, t_{{l_{i}}}}
    =
    \boldsymbol{\alpha}_{\Delta t_{{l_{i}}}}
    +
    \boldsymbol{\beta}_{\Delta t_{{l_{i}}}}
    \boldsymbol{\eta}_{i, t_{l_{i} - 1}}
    +
    \boldsymbol{\zeta}_{i, t_{{l_{i}}}},
    \quad
    \mathrm{with}
    \quad
    \boldsymbol{\zeta}_{i, t_{{l_{i}}}}
    \sim
    \mathcal{N}
    \left(
    \mathbf{0},
    \boldsymbol{\Psi}_{\Delta t_{{l_{i}}}}
    \right)
  }
with
\deqn{
      \boldsymbol{\beta}_{\Delta t_{{l_{i}}}}
      =
      \exp{
        \left(
          \Delta t
          \boldsymbol{\Phi}
        \right)
      },
  }

\deqn{
      \boldsymbol{\alpha}_{\Delta t_{{l_{i}}}}
      =
      \boldsymbol{\Phi}^{-1}
      \left(
        \boldsymbol{\beta} - \mathbf{I}_{p}
      \right)
      \boldsymbol{\iota}, \quad \mathrm{and}
  }

\deqn{
      \mathrm{vec}
      \left(
        \boldsymbol{\Psi}_{\Delta t_{{l_{i}}}}
      \right)
      =
      \left[
        \left(
          \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
        \right)
        +
        \left(
          \mathbf{I}_{p} \otimes \boldsymbol{\Phi}
        \right)
      \right]
      \left[
        \exp
        \left(
          \left[
            \left(
              \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
            \right)
            +
            \left(
              \mathbf{I}_{p} \otimes \boldsymbol{\Phi}
            \right)
          \right]
          \Delta t
        \right)
        -
        \mathbf{I}_{p \times p}
      \right]
      \mathrm{vec}
      \left(
        \boldsymbol{\Sigma}
      \right)
  }
where \eqn{t} denotes continuous-time processes
that can be defined by any arbitrary time point,
\eqn{t_{l_{i}}} the \eqn{l^\mathrm{th}}
observed measurement occassion for individual \eqn{i},
\eqn{p} the number of latent variables and
\eqn{\Delta t} the time interval.
}
\examples{
p <- 2
iota <- c(0.317, 0.230)
phi <- matrix(
  data = c(
   -0.10,
   0.05,
   0.05,
   -0.10
 ),
 nrow = p
)
sigma <- matrix(
  data = c(
    2.79,
    0.06,
    0.06,
    3.27
  ),
  nrow = p
)
sigma_l <- t(chol(sigma))
delta_t <- 0.10

LinSDE2SSM(
  iota = iota,
  phi = phi,
  sigma_l = sigma_l,
  delta_t = delta_t
)

}
\references{
Harvey, A. C. (1990).
Forecasting, structural time series models and the Kalman filter.
Cambridge University Press.
\doi{10.1017/cbo9781107049994}
}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
\keyword{transformation}
