% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{plotDefectAcc}
\alias{plotDefectAcc}
\title{Draw accumulation path defect areas}
\usage{
plotDefectAcc(CL, last.path = FALSE, log.axis = "x",
  main = "Accumulation of particle's projection areas")
}
\arguments{
\item{CL}{cluster of aggregated (densified objects), see \code{\link{simFracture}}}

\item{last.path}{logical, \code{last.path=FALSE} (default), show the critical area accumulation path
leading to the overall failure}

\item{log.axis}{character, \code{log.axis='x'} (default), switch to logarithmic scale}

\item{main}{optional, main title of the plot}
}
\value{
the accumulation path of defect areas as a list containing the
						starting and end points of each horizontal line (the current convex hull area value)
					    together with the starting point of the next convex hull of defect projections and 
					    whether the defect occured in the interior or at the boundaries of the simulation box
}
\description{
Plot accumulation of defect projection areas
}
\details{
Simple plotting function to visualize the process of accumulation of defect areas separately
for interior objects and objects hitting the boundaries of the simulation box (specimen)
}

