% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Shuttleworth_Wallace.R
\name{cal_totalLatentHeatFlux}
\alias{cal_totalLatentHeatFlux}
\title{Calculating total latent heat flux}
\usage{
cal_totalLatentHeatFlux(
  DELTA,
  gamma,
  r_a_a,
  r_c_a,
  r_s_a,
  r_c_s,
  r_s_s,
  A,
  rho_cp = 1221.09,
  D,
  As,
  Ac
)
}
\arguments{
\item{DELTA}{the slope of the saturated vapor pressure curve (mbar K-1)}

\item{gamma}{is the psychometric constant (0.658 mbar K-1)}

\item{r_a_a}{the aerodynamic resistance between the mean canopy flow and reference height (s m-1)}

\item{r_c_a}{the bulk boundary layer resistance (s m-1)}

\item{r_s_a}{is the aerodynamic resistance between the soil and mean canopy flow (s m-1)}

\item{r_c_s}{the canopy resistance(s m-1)}

\item{r_s_s}{soil surface resistance (s m-1)}

\item{A}{energy available to the system (total)(W m-2 ground)}

\item{rho_cp}{is the volumetric heat capacity for air (1221.09 J m-3 K-1)}

\item{D}{the vapor pressure deficit (mbar)}

\item{As}{energy available to soil (W m-2 ground)}

\item{Ac}{energy available to crop (W m-2 ground)}
}
\value{
A vector for the total latent heat flux (W m-2 ground)
}
\description{
Calculating total latent heat flux
}
