% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_Y_Binary_X.R
\name{sim_Y_Binary_X}
\alias{sim_Y_Binary_X}
\title{Simulate Scalar Outcomes from Simulated Spatially Dependent Binary Predictors}
\usage{
sim_Y_Binary_X(
  N,
  B,
  rand.err = 1,
  dist,
  incl.subjectID = TRUE,
  binomial.method = "traditional",
  count.method = "traditional",
  Y.thresh = NULL,
  print.out = FALSE,
  xlim = c(0, 1),
  ylim = c(0, 1),
  im.res,
  radius.bounds = c(0.02, 0.1),
  lambda = 50,
  random.lambda = FALSE,
  lambda.sd = 10,
  lambda.bound = NULL,
  prior = "gamma",
  sub.area = FALSE,
  min.sa = c(0.1, 0.1),
  max.sa = c(0.3, 0.3),
  radius.bounds.min.sa = c(0.02, 0.05),
  radius.bounds.max.sa = c(0.08, 0.15),
  print.subj.sa = FALSE,
  print.lambda = FALSE,
  print.iter = FALSE
)
}
\arguments{
\item{N}{A scalar value determining the number of images to create.}

\item{B}{A vector parameter values; i.e. "betas". Note that \code{length(B)}
must equal \code{p + 1 = n.row * n.col + 1}; e.g. for normal outcomes
\eqn{Y = XB + e} with \code{Y} a scalar outcome and \code{e} the random error.}

\item{rand.err}{A scalar for the random error variance when \code{dist = "gaussian"}.}

\item{dist}{The distribution of the scalar outcome.
\itemize{
    \item \code{dist = "gaussian"} has \eqn{Y = XB + e}, where
    \eqn{e ~ N(0, rand.err)}.
    \item \code{dist = "binomial"} is drawn from eqn{Bin(XB, XB(1-XB))}
    using \code{rbinom()} when \code{binary.method = "Traditional"}. If
    \code{binary.method = "Gaussian"}, then simulation is based on a
    cutoff using \code{binary.cutoff}.
    \item \code{dist = "poisson"} is drawn from \eqn{Poisson(XB)} using
    \code{rpois()}.
}}

\item{incl.subjectID}{When \code{incl.subjectID = TRUE} a column of subject indices
is generated.
\code{Y.thresh = NULL} (default). If \code{binomial.method = "gaussian manual"},
then \code{Y.thresh} should be any scalar real number; values equal or above
 this cutoff are assigned 1 and values below are assigned 0.
 If \code{binomial.method = "gaussian percentile"}, then values equal or above
 this percentile are assigned 1, and other wise 0; in this case values should
 be between 0 and 1. For example, if \code{Y.thresh = 0.9}, then the
 cutoff is the 90th percentile.}

\item{binomial.method}{One of \code{c("traditional", "gaussian manual", "gaussian percentile")}.
Only specified when \code{dist = "binomial"}, and determines
whether draws are directly taken from a binomial distribution or if draws are
taken from a Multivariate Normal Distribution (in the manner of \code{dist = "gaussian"})
and thresholds imposed to binarize the outcomes. \code{binomial.method = "gaussian manual"}
allows the user to specify specific values for categorizing outcomes. \code{binomial.method = "gaussian percentile"}
allows the user to specify percentiles for binarizing the data. Both approaches use
\code{Y.thresh} to specify the cutoff value(s). If \code{binomial.method = "gaussian percentile"}
and \code{Y.thresh = NULL} then the median is used as the threshold. If
\code{binomial.method = "gaussian manual"} and \code{Y.thresh = NULL}, then 0 is used as
the threshold. Default is \code{binomial.method = "traditional"}.}

\item{count.method}{One of \code{c("traditional", "rounding")}. When \code{count.method = "traditional"},
the outcomes are drawn sequentially using \code{rpois()}. When \code{count.method = "traditional"},
the outcomes are drawn from an MVN, then values less than or equal to 0 are set to 0, and all other
values are rounded to the nearest whole number.}

\item{Y.thresh}{When \code{binomial.method = "traditional"}}

\item{print.out}{If \code{print.out = TRUE} then print the following for
 each subject, indexed y: \itemize{
     \item \code{X[y] \%*\% B}
     \item \code{p[y]}, \code{lambda[y]} for Binomial, Poisson, respectively.
 }
This is useful to see the effect of image parameter selection and beta
parameter selection on distributional parameters for the outcome of interest.}

\item{xlim}{These are the 2D image limits. Defaults for both are \code{c(0, 1)}.
It is not recommended to alter these arguments unless changing the limits has a
specific practical utility.}

\item{ylim}{These are the 2D image limits. Defaults for both are \code{c(0, 1)}.
It is not recommended to alter these arguments unless changing the limits has a
specific practical utility.}

\item{im.res}{A vector specifying the dimension/resolution of the image. The first entry is
the number of 'rows' in the lattice/image, and the second entry is the number of
'columns' in the lattice/image.}

\item{radius.bounds}{A 2-element vector whose first and second entries determine
the minimum and maximum radius sizes, respectively; these will be the bounds
of the uniform distribution used to draw the radii. If \code{sub.area = TRUE}, then
use \code{radius.bounds.min.sa} and \code{radius.bounds.max.sa}.}

\item{lambda}{A scalar value specifying the mean/intensity value of the Poisson process.
If \code{random.lambda = FALSE} then this is the parameter used to generate the binary
image for each subject. If \code{random.lambda = TRUE}, then this is the mean parameter
in the distribution used to draw subject-specific lambda.}

\item{random.lambda}{\code{random.lambda = TRUE} allows the lambda (mean/intensity)
parameter in the Poisson process to vary randomly by subject.}

\item{lambda.sd}{Only utilized when \code{random.lambda = TRUE}, and specifies the
standard deviation in the distribution used to draw subject-specific lambda.}

\item{lambda.bound}{Only utilized when \code{random.lambda = TRUE}, and allows the
user to specify a lower and upper bound for the subject-specific lambda; if the
randomly selected value is outside of this range, then another draw is taken. This
continues until a value is selected within the specified bounds. If no bounds are
desired then specify \code{lambda.bound = NULL}.}

\item{prior}{Only utilized when \code{random.lambda = TRUE}, and specifies the
distribution from which to draw the subject-specific lambda.
Options are \code{c("gaussian", "gamma")}.}

\item{sub.area}{When \code{sub.area = TRUE}, a random sub-section of the image is
chosen, within which the Poisson process is used to generate the binary image.}

\item{min.sa}{Only utilized when \code{sub.area = TRUE}, and
determines the width and height of the  minimum and maximum sub-areas; e.g., if
\code{min.sa = c(0.1, 0.1)}, then the smallest possible random sub-area is a
0.1 x 0.1 square.}

\item{max.sa}{Only utilized when \code{sub.area = TRUE}, and
determines the width and height of the  minimum and maximum sub-areas; e.g., if
\code{min.sa = c(0.1, 0.1)}, then the smallest possible random sub-area is a
0.1 x 0.1 square.}

\item{radius.bounds.min.sa}{Only utilized when \code{sub.area = TRUE}, and
specifies \code{radius.bounds} for the minimum and maximum sub-areas, respectively.
This information is used to adaptively alter the bounds in between the minimum and maximum
sub-areas.}

\item{radius.bounds.max.sa}{Only utilized when \code{sub.area = TRUE}, and
specifies \code{radius.bounds} for the minimum and maximum sub-areas, respectively.
This information is used to adaptively alter the bounds in between the minimum and maximum
sub-areas.}

\item{print.subj.sa}{These arguments are either
\code{TRUE} or \code{FALSE}, and define print options for checking that the
function is working as the user intends. \code{print.subj.sa = TRUE} prints the x-
and y-limits for each subject's sub-area. \code{print.lambda = TRUE} prints each
subject's mean and realized events; the means will be the same unless \code{random.lambda = TRUE},
but the number of realized events will always vary. \code{print.iter = TRUE} is
only used when \code{random.lambda = TRUE} and \code{is.null(lambda.bound) = FALSE},
and shows iterations for re-drawing when the randomly selected intensity is outside
the specified bounds.}

\item{print.lambda}{These arguments are either
\code{TRUE} or \code{FALSE}, and define print options for checking that the
function is working as the user intends. \code{print.subj.sa = TRUE} prints the x-
and y-limits for each subject's sub-area. \code{print.lambda = TRUE} prints each
subject's mean and realized events; the means will be the same unless \code{random.lambda = TRUE},
but the number of realized events will always vary. \code{print.iter = TRUE} is
only used when \code{random.lambda = TRUE} and \code{is.null(lambda.bound) = FALSE},
and shows iterations for re-drawing when the randomly selected intensity is outside
the specified bounds.}

\item{print.iter}{These arguments are either
\code{TRUE} or \code{FALSE}, and define print options for checking that the
function is working as the user intends. \code{print.subj.sa = TRUE} prints the x-
and y-limits for each subject's sub-area. \code{print.lambda = TRUE} prints each
subject's mean and realized events; the means will be the same unless \code{random.lambda = TRUE},
but the number of realized events will always vary. \code{print.iter = TRUE} is
only used when \code{random.lambda = TRUE} and \code{is.null(lambda.bound) = FALSE},
and shows iterations for re-drawing when the randomly selected intensity is outside
the specified bounds.}
}
\value{
A data frame where each row consists of a single subject's data.
Col 1 is the outcome, Y, and each successive column contains the subject
predictor values.
}
\description{
N spatially dependent binary design vectors are simulated using \code{sim2D_binarymap}.
These design vectors are used to then simulate scalar outcomes that have
one of Gaussian, Binomial, or Poisson distributions.
}
\note{
Careful parameter selection, i.e. \code{B}, is necessary to ensure that
simulated outcomes are reasonable; in particular, counts arising from the Poisson
distribution can be unnaturally large.
}
\examples{

## Define non-zero beta values
Bex <- beta_builder(row.index = c(3, 3, 4), col.index = c(3, 4, 3),
                    im.res = c(5, 5),
                    B0 = 0, B.values = rep(1/3, 3),
                    output.indices = FALSE)
## Simulate Datasets
## parameter values
Nex = 10
set.seed(28743)

Gauss.ex <- sim_Y_Binary_X(N = Nex, B = Bex, dist = "gaussian", im.res = c(5, 5))
hist(Gauss.ex$Y)

## direct draws from binomial
Bin.ex <- sim_Y_Binary_X(N = Nex, B = Bex, im.res = c(5, 5),
                         dist = "binomial", print.out = TRUE)
table(Bin.ex$Y)
}
\references{
\insertRef{Cressie+Wikle:2011}{sim2Dpredictr}

\insertRef{Ripley:1987}{sim2Dpredictr}
}
