% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination.R
\name{generateFakeWholeGenomeGeneticMap}
\alias{generateFakeWholeGenomeGeneticMap}
\title{Generates a fake genetic map that spans the whole genome.}
\usage{
generateFakeWholeGenomeGeneticMap(vcf)
}
\arguments{
\item{vcf}{A vcf file read by function readVCF.}
}
\description{
Generates a fake genetic map that spans the whole genome.
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = sprintf("\%s/region.vcf.gz", examples_dir)
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 ,
               min_maf = 0.12 ,max_maf = NA)

# For realistic data use the function
# downloadGeneticMap
generateFakeWholeGenomeGeneticMap(vcf)

pdf(file=tempfile())
plotRegionalGeneticMap(seq(1e6,100e6,by=1e6/2))
dev.off()

}
