% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{find_ROC_matching_ab1}
\alias{find_ROC_matching_ab1}
\title{Find beta-1 shape parameters matching the conditional distributions.}
\usage{
find_ROC_matching_ab1(modelPredictions, yValues, ..., yTarget = TRUE)
}
\arguments{
\item{modelPredictions}{numeric predictions (not empty), ordered (either increasing or decreasing)}

\item{yValues}{truth values (not empty, same length as model predictions)}

\item{...}{force later arguments to bind by name.}

\item{yTarget}{value considered to be positive.}
}
\value{
beta curve shape parameters
}
\description{
Based on \url{https://journals.sagepub.com/doi/abs/10.1177/0272989X15582210}
}
\examples{

d <- rbind(
  data.frame(x = rbeta(1000, shape1 = 6, shape2 = 4), y = TRUE),
  data.frame(x = rbeta(1000, shape1 = 2, shape2 = 5), y = FALSE)
)
find_ROC_matching_ab1(modelPredictions = d$x, yValues = d$y)
# should be near
# shape1_pos shape2_pos shape1_neg shape2_neg          a          b
#   3.985017   1.000000   1.000000   1.746613   3.985017   1.746613
#
# # How to land what you want as variables
# unpack[a, b] <-
#    find_ROC_matching_ab1(modelPredictions = d$x, yValues = d$y)

}
