% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TInterval.R
\name{render.sigr_tinterval}
\alias{render.sigr_tinterval}
\title{Format a Student-T tolerance-style interval around an estimate of a mean.}
\usage{
\method{render}{sigr_tinterval}(
  statistic,
  ...,
  format,
  statDigits = 4,
  sigDigits = 4,
  pLargeCutoff = 0.05,
  pSmallCutoff = 1e-05
)
}
\arguments{
\item{statistic}{wrapped TInterval.}

\item{...}{extra arguments (not used)}

\item{format}{if set the format to return ("html", "latex", "markdown", "ascii", "docx", ...)}

\item{statDigits}{integer number of digits to show in summaries.}

\item{sigDigits}{integer number of digits to show in significances.}

\item{pLargeCutoff}{value to declare non-significance at or above.}

\item{pSmallCutoff}{smallest value to print}
}
\value{
formatted string
}
\description{
Report sample size (n), sample mean, bias-corrected standard deviation estimate
(assuming normality, using a chi-square distribution correction
from \url{https://en.wikipedia.org/wiki/Unbiased_estimation_of_standard_deviation#Bias_correction}),
and a Student t-test tolerance-style confidence interval.
}
\examples{

set.seed(2018)
d <- rnorm(100) + 3.2
TInterval(d)

}
