% Generated by roxygen2 (4.0.2): do not edit by hand
\name{degenerate}
\alias{degenerate}
\title{Degenerate protein sequence}
\usage{
degenerate(seq, aa_group)
}
\arguments{
\item{seq}{\code{character} vector representing single aminoacid sequence.}

\item{aa_group}{list of aminoacid groups to which sequence should be aggregated.}
}
\value{
a \code{character} vector.
}
\description{
'Degenerates' protein sequence by aggregating aminoacids to bigger groups.
}
\examples{
sample_seq <- sample(seqinr:::a()[-1], 30, replace = TRUE)
table(sample_seq)

#compared with aggregated sequence
deg_seq <- degenerate(sample_seq, aaaggregation)
table(deg_seq)
}
\keyword{manip}

