% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_catalogue.R
\name{show_catalogue}
\alias{show_catalogue}
\title{Show Alteration Catalogue Profile}
\usage{
show_catalogue(
  catalogue,
  mode = c("SBS", "copynumber", "DBS", "ID", "RS"),
  method = "Wang",
  normalize = c("raw", "row", "feature"),
  style = c("default", "cosmic"),
  samples = NULL,
  samples_name = NULL,
  x_lab = "Components",
  y_lab = "Counts",
  ...
)
}
\arguments{
\item{catalogue}{result from \link{sig_tally} or a
matrix with row representing components (motifs) and
column representing samples}

\item{mode}{signature type for plotting, now supports 'copynumber', 'SBS',
'DBS', 'ID' and 'RS' (genome rearrangement signature).}

\item{method}{method for copy number feature classification in \link{sig_tally},
can be one of "Wang" ("W"), "S".}

\item{normalize}{normalize method.}

\item{style}{plot style, one of 'default' and 'cosmic'.}

\item{samples}{default is \code{NULL}, show sum of all samples in one row.
If not \code{NULL}, show specified samples.}

\item{samples_name}{set the sample names shown in plot.}

\item{x_lab}{x axis lab.}

\item{y_lab}{y axis lab.}

\item{...}{other arguments passing to \link{show_sig_profile}.}
}
\value{
a \code{ggplot} object
}
\description{
Show Alteration Catalogue Profile
}
\examples{
data("simulated_catalogs")
p <- show_catalogue(simulated_catalogs$set1, style = "cosmic")
p
}
