% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testIndepTimeMark.R
\name{testIndepTimeMark}
\alias{testIndepTimeMark}
\title{Kolmogorov-Smirnov-Type Test of Conditional Independence between the Time-to-Event
and a Multivariate Mark Given Treatment}
\usage{
testIndepTimeMark(data, iter = 1000)
}
\arguments{
\item{data}{a data frame restricted to subjects in a given treatment group with the following columns (in this order): the observed right-censored time to the event of interest,
the event indicator (1 if event, 0 if right-censored), and the mark variable (one column for each component, if multivariate)}

\item{iter}{the number of bootstrap iterations (1000 by default) used for computing the p-value}
}
\value{
Returns the bootstrap p-value from the test of conditional independence between \eqn{T} and \eqn{V} given \eqn{Z}.
}
\description{
A nonparametric Komogorov-Smirnov-type test of the null hypothesis that the time-to-event \eqn{T} and a possibly multivariate mark \eqn{V} are conditionally independent given treatment \eqn{Z}
as described in Juraska and Gilbert (2013). The conditional independence is a necessary assumption for parameter identifiability in the time-independent density ratio model. A bootstrap
algorithm is used to compute the p-value.
}
\details{
The test statistic is the supremum of the difference between the estimated conditional joint cumulative distribution function (cdf) of \eqn{(T,V)} given \eqn{Z} and the product of
the estimated conditional cdfs of \eqn{T} and \eqn{V} given \eqn{Z}. The joint cdf is estimated by the nonparametric maximum likelihood estimator developed by
Huang and Louis (1998). The marginal cdf of \eqn{T} is estimated as one minus the Kaplan-Meier estimator for the conditional survival function of \eqn{T}, and the
cdf of \eqn{V} is estimated as the empirical cdf of the observed values of \eqn{V}. A bootstrap algorithm is used to compute the p-value.
}
\examples{
n <- 500
tx <- rep(0:1, each=n/2)
tm <- c(rexp(n/2, 0.2), rexp(n/2, 0.2 * exp(-0.4)))
cens <- runif(n, 0, 15)
eventTime <- pmin(tm, cens, 3)
eventInd <- as.numeric(tm <= pmin(cens, 3))
mark1 <- ifelse(eventInd==1, c(rbeta(n/2, 2, 5), rbeta(n/2, 2, 2)), NA)
mark2 <- ifelse(eventInd==1, c(rbeta(n/2, 1, 3), rbeta(n/2, 5, 1)), NA)

# perform the test for a univariate mark in the placebo group
testIndepTimeMark(data.frame(eventTime, eventInd, mark1)[tx==0, ], iter=20)

# perform the test for a bivariate mark in the placebo group
testIndepTimeMark(data.frame(eventTime, eventInd, mark1, mark2)[tx==0, ], iter=20)

}
\references{
Juraska, M. and Gilbert, P. B. (2013), Mark-specific hazard ratio model with multivariate continuous marks: an application to vaccine efficacy. \emph{Biometrics} 69(2):328–337.

Huang, Y. and Louis, T. (1998), Nonparametric estimation of the joint distribution of survival time and mark variables. \emph{Biometrika} 85, 785–798.
}
