% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmoidalFitFunctions.R
\name{sigmoidalFitFunction}
\alias{sigmoidalFitFunction}
\title{Sigmoidal fit function}
\usage{
sigmoidalFitFunction(dataInput, tryCounter, startList = list(maximum = 1,
  slopeParam = 1, midPoint = 0.33), lowerBounds = c(maximum = 0.3, slopeParam
  = 0.01, midPoint = -0.52), upperBounds = c(maximum = 1.5, slopeParam = 180,
  midPoint = 1.15), min_Factor = 1/2^20, n_iterations = 1000)
}
\arguments{
\item{dataInput}{A data frame or a list contatining the dataframe. The data frame should be composed of at least two columns. One represents time, and the other represents intensity. The data should be normalized with the normalize data function sicegar::normalizeData() before imported into this function.}

\item{tryCounter}{A counter that shows the number of times the data was fit via maximum likelihood function.}

\item{startList}{The initial set of parameters vector that algorithm tries for the first fit attempt for the relevant parameters. The vector composes of three elements; 'maximum', 'slopeParam' and, 'midPoint'.  Detailed explanations of those parameters can be found in vignettes. Defaults are maximum = 1, slopeParam = 1 and, midPoint = 0.33. The numbers are in normalized time intensity scale.}

\item{lowerBounds}{The lower bounds for the randomly generated start parameters.  The vector composes of three elements; 'maximum', 'slopeParam' and, 'midPoint'. Detailed explanations of those parameters can be found in vignettes. Defaults are maximum = 0.3, slopeParam = 0.01, and midPoint = -0.52. The numbers are in normalized time intensity scale.}

\item{upperBounds}{The upper bounds for the randomly generated start parameters.  The vector composes of three elements; 'maximum', 'slopeParam' and, 'midPoint'. Detailed explanations of those parameters can be found in vignettes. Defaults are maximum = 1.5, slopeParam = 180,  midPoint = 1.15. The numbers are in normalized time intensity scale.}

\item{min_Factor}{Defines the minimum step size used by the fitting algorithm. Default is 1/2^20.}

\item{n_iterations}{Defines maximum number of iterations used by the fitting algorithm. Default is 1000}
}
\value{
Returns fitted parameters for the sigmoidal model.
}
\description{
The function fits a sigmoidal curve to given data by using likelihood maximization (LM) algorithm and provides the parameters (maximum, slopeParam and, midPoint) describing the double-sigmoidal fit as output. It also contains information about the goodness of fits such as AIC, BIC, residual sum of squares, and log likelihood.
}
\examples{
time <- seq(3, 24, 0.5)

#simulate intensity data and add noise
noise_parameter <- 0.1
intensity_noise <- stats::runif(n = length(time), min = 0, max = 1) * noise_parameter
intensity <- sigmoidalFitFormula(time, maximum = 4, slopeParam = 1, midPoint = 8)
intensity <- intensity + intensity_noise

dataInput <- data.frame(intensity = intensity, time = time)
normalizedInput <- normalizeData(dataInput)
parameterVector <- sigmoidalFitFunction(normalizedInput, tryCounter = 2)

#Check the results
if(parameterVector$isThisaFit){
intensityTheoretical <- sigmoidalFitFormula(time,
                                           maximum = parameterVector$maximum_Estimate,
                                           slopeParam = parameterVector$slopeParam_Estimate,
                                           midPoint = parameterVector$midPoint_Estimate)

comparisonData <- cbind(dataInput, intensityTheoretical)

require(ggplot2)
ggplot(comparisonData) +
 geom_point(aes(x = time, y = intensity)) +
 geom_line(aes(x = time, y = intensityTheoretical)) +
 expand_limits(x = 0, y = 0)
}

if(!parameterVector$isThisaFit){
  print(parameterVector)
}

}
