% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel_query.R
\name{cancel_query}
\alias{cancel_query}
\title{Cancel Query}
\usage{
cancel_query(
  query_run_id,
  api_key,
  api_url = "https://api-v2.flipsidecrypto.xyz/json-rpc"
)
}
\arguments{
\item{query_run_id}{queryRunId from `create_query_token()`, for token stored as `x`, use `x$result$queryRequest$queryRunId`}

\item{api_key}{Flipside Crypto ShroomDK API Key}

\item{api_url}{default to https://api-v2.flipsidecrypto.xyz/json-rpc but upgradeable for user.}
}
\value{
returns a list of the status_canceled (TRUE or FALSE) and the cancel object (which includes related details).
}
\description{
Uses Flipside ShroomDK to CANCEL a query run id from `create_query_token()`, as the new API uses warehouse-seconds to charge users above the free tier,
the ability to cancel is critical for cost management.
}
\examples{
\dontrun{
query <- create_query_token("SELECT * FROM ETHEREUM.CORE.FACT_TRANSACTIONS LIMIT 1000000", api_key)
query_status <- get_query_status(query$result$queryRequest$queryRunId, api_key)
canceled <- cancel_query(query$result$queryRequest$queryRunId, api_key)
}
}
