% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_token.R
\name{create_query_token}
\alias{create_query_token}
\title{Create Query Token}
\usage{
create_query_token(
  query,
  api_key,
  ttl = 1,
  mam = 10,
  api_url = "https://api-v2.flipsidecrypto.xyz/json-rpc"
)
}
\arguments{
\item{query}{Flipside Crypto Snowflake SQL compatible query as a string.}

\item{api_key}{Flipside Crypto ShroomDK API Key}

\item{ttl}{time-to-live (in hours) to keep query results available. Default 1 hour.}

\item{mam}{max-age-minutes, lifespan of cache. set to 0 to always re-execute. Default 10 minutes.}

\item{api_url}{default to https://api-v2.flipsidecrypto.xyz/json-rpc but upgradeable for user.}
}
\value{
list of `token` and `cached` use `token` in `get_query_from_token()`
}
\description{
Uses Flipside ShroomDK to create a Query Token to access Flipside Crypto
data. The query token is cached up to ttl minutes
allowing for pagination and multiple requests before expending more daily request uses.
}
\examples{
\dontrun{
create_query_token(
query = "SELECT * FROM ethereum.core.fact_transactions LIMIT 1",
api_key = readLines("api_key.txt"),
ttl = 1,
mam = 5)
}
}
