% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_token.R
\name{create_query_token}
\alias{create_query_token}
\title{Create Query Token}
\usage{
create_query_token(query, api_key, ttl = 10, cache = TRUE)
}
\arguments{
\item{query}{Flipside Crypto Snowflake SQL compatible query as a string.}

\item{api_key}{Flipside Crypto ShroomDK API Key}

\item{ttl}{time (in minutes) to keep query in cache.}

\item{cache}{Use cached results; set as FALSE to re-execute.}
}
\value{
list of `token` and `cached` use `token` in `get_query_from_token()`
}
\description{
Uses Flipside ShroomDK to create a Query Token to access Flipside Crypto
data. The query token is cached up to ttl minutes
allowing for pagination and multiple requests before expending more daily request uses.
}
\examples{
\dontrun{
create_query_token(
query = "SELECT * FROM ethereum.core.fact_transactions LIMIT 1",
api_key = readLines("api_key.txt"),
ttl = 15,
cache = TRUE)
}
}
