% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{sv_integer}
\alias{sv_integer}
\title{Validate that a field is a number that is integer-like}
\usage{
sv_integer(
  message = "An integer is required",
  allow_multiple = FALSE,
  allow_na = FALSE,
  allow_nan = FALSE
)
}
\arguments{
\item{message}{The validation error message to use if a value is not an
integer.}

\item{allow_multiple}{If \code{FALSE} (the default), then the length of the input
vector must be exactly one; if \code{TRUE}, then any length is allowed
(including a length of zero; use \code{\link[=sv_required]{sv_required()}} if one or more values
should be required).}

\item{allow_na}{If \code{FALSE} (the default for both options), then any
\code{NA} or \code{NaN} element will cause validation to fail.}

\item{allow_nan}{If \code{FALSE} (the default for both options), then any
\code{NA} or \code{NaN} element will cause validation to fail.}
}
\value{
A function suitable for use as an
\code{\link[=InputValidator]{InputValidator$add_rule()}} rule.
}
\description{
The \code{sv_integer()} function validates that a field is 'integer-like' with the
\code{{value} \%\% 1 == 0} test. Very large values (generally with absolute exponent
values greater than 15) won't be validated correctly due to floating point
imprecision. By default, only a single, finite, not-missing, valid numbers
are allowed, but each of those criteria can be controlled via arguments.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinyvalidate)

ui <- fluidPage(
  textInput("count", "Count")
)

server <- function(input, output, session) {
  
  # Validation rules are set in the server, start by
  # making a new instance of an `InputValidator()`
  iv <- InputValidator$new()

  # Basic usage: `sv_integer()` works well with its
  # defaults; a message will be displayed if the
  # validation of `input$count` fails
  iv$add_rule("count", sv_integer())

  # Finally, `enable()` the validation rules
  iv$enable()
}

shinyApp(ui, server)

}

}
\seealso{
The \code{\link[=sv_numeric]{sv_numeric()}} function, which tests whether a field value is
simply numeric.

Other rule functions: 
\code{\link{compose_rules}()},
\code{\link{sv_between}()},
\code{\link{sv_email}()},
\code{\link{sv_equal}()},
\code{\link{sv_gte}()},
\code{\link{sv_gt}()},
\code{\link{sv_in_set}()},
\code{\link{sv_lte}()},
\code{\link{sv_lt}()},
\code{\link{sv_not_equal}()},
\code{\link{sv_numeric}()},
\code{\link{sv_optional}()},
\code{\link{sv_regex}()},
\code{\link{sv_required}()},
\code{\link{sv_url}()}
}
\concept{rule functions}
