% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-app.R
\name{test_app}
\alias{test_app}
\title{Test Shiny applications with \pkg{testthat}}
\usage{
test_app(app_dir = missing_arg(), ..., check_setup = TRUE)
}
\arguments{
\item{app_dir}{The base directory for the Shiny application.
\itemize{
\item If \code{app_dir} is missing and \code{test_app()} is called within the
\code{./tests/testthat.R} file, the parent directory (\code{"../"}) is used.
\item Otherwise, the default path of \code{"."} is used.
}}

\item{...}{Parameters passed to \code{\link[testthat:test_dir]{testthat::test_dir()}}}

\item{check_setup}{If \code{TRUE}, the app will be checked for the presence of
\code{./tests/testthat/setup.R}. This file must contain a call to
\code{\link[=load_app_env]{load_app_env()}}.}
}
\description{
This is a helper method that wraps around \code{\link[testthat:test_dir]{testthat::test_dir()}} to test your Shiny application or Shiny runtime document.  This is similar to how \code{\link[testthat:test_package]{testthat::test_check()}} tests your R package but for your app.
}
\details{
When setting up tests for your app,

Example usage:\if{html}{\out{<div class="sourceCode r">}}\preformatted{## Interactive usage
# Test Shiny app in current working directory
shinytest2::test_app()

# Test Shiny app in another directory
path_to_app <- "path/to/app"
shinytest2::test_app(path_to_app)

## File: ./tests/testthat.R
# Will find Shiny app in "../"
shinytest2::test_app()

## File: ./tests/testthat/test-shinytest2.R
# Test a shiny application within your own \{testthat\} code
test_that("Testing a Shiny app in a package", \{
  shinytest2::test_app(path_to_app)
\})
}\if{html}{\out{</div>}}
}
\section{Uploading files}{


When testing an application, all non-temp files that are uploaded should be
located in the \code{./tests/testthat} directory. This allows for tests to be more
portable and self contained.

When recording a test with \code{\link[=record_test]{record_test()}}, for every uploaded file that is
located outside of \code{./tests/testthat}, a warning will be thrown. Once the
file path has be fixed, you may remove the warning statement.
}

\section{Different ways to test}{


\code{test_app()} is an opinionated testing function that will only execute
\pkg{testthat} tests in the \code{./tests/testthat} folder. If (for some rare
reason) you have other non-\pkg{testthat} tests to execute, you can call
\code{\link[shiny:runTests]{shiny::runTests()}}. This method will generically run all test runners and
their associated tests.\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Execute a single Shiny app's \{testthat\} file such as `./tests/testthat/test-shinytest2.R`
test_app(filter = "shinytest2")

# Execute all \{testthat\} tests
test_app()

# Execute all tests for all test runners
shiny::runTests()
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \code{\link[=record_test]{record_test()}} to create tests to record against your Shiny application.
\item \code{\link[testthat:snapshot_accept]{testthat::snapshot_review()}} and \code{\link[testthat:snapshot_accept]{testthat::snapshot_accept()}} if
you want to compare or update snapshots after testing.
\item \code{\link[=load_app_env]{load_app_env()}} to load the Shiny application's helper files.
This is only necessary if you want access to the values while testing.
}
}
