% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{screen}
\alias{screen}
\title{Screen creation}
\usage{
screen(..., next_label = NULL, previous_label = NULL,
  next_condition = NULL, previous_condition = NULL, class = NULL)
}
\arguments{
\item{...}{content of the screen.}

\item{next_label}{specific label of the "next" control for this screen. If \code{NULL},
use the default one for the current glide.}

\item{previous_label}{specific label of the "back" control for this screen. If \code{NULL},
use the default one for the current glide.}

\item{next_condition}{condition for the "next" control to be enabled. Same syntax
as \code{shiny::conditionalPanel}.}

\item{previous_condition}{condition for the "back" control to be enabled. Same syntax
as \code{shiny::conditionalPanel}.}

\item{class}{screen CSS classes. \code{glide__slide} is automatically added.}
}
\description{
Insert a new screen into a glide component.
}
\details{
This function inserts a new "screen" into an existing \code{glide} component. It
can only be used inside a \code{glide()} call, in a shiny app UI.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fixedPage(
 h3("Simple shinyglide app"),
 glide(
    screen(
      next_label = "Go next",
      next_condition = "input.x > 0",
      p("First screen."),
      numericInput("x", "x", value = 0)
    ),
    screen(
      p("Final screen."),
    )
  )
)

server <- function(input, output, session) {
}

shinyApp(ui, server)

}

}
\seealso{
glide
}
