% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhanced-boxes.R
\name{boxProfile}
\alias{boxProfile}
\title{AdminLTE2 box profile}
\usage{
boxProfile(..., src = NULL, title = NULL, subtitle = NULL)
}
\arguments{
\item{...}{any element such as boxProfileItemList.}

\item{src}{profile image, if any.}

\item{title}{title.}

\item{subtitle}{subtitle.}
}
\description{
Create box profile
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Box with profile",
      status = "primary",
      boxProfile(
       src = "https://adminlte.io/themes/AdminLTE/dist/img/user4-128x128.jpg",
       title = "Nina Mcintire",
       subtitle = "Software Engineer",
       boxProfileItemList(
        bordered = TRUE,
        boxProfileItem(
         title = "Followers",
         description = 1322
        ),
        boxProfileItem(
         title = "Following",
         description = 543
        ),
        boxProfileItem(
         title = "Friends",
         description = 13287
        )
       )
      )
     )
    ),
    title = "boxProfile"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
