% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menuOutput.R
\name{renderMenu}
\alias{renderMenu}
\title{Create dynamic menu output (server side)}
\usage{
renderMenu(expr, env = parent.frame(), quoted = FALSE,
  outputArgs = list())
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, \code{\link{HTML}},
or a list of such objects.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link{uiOutput}} when \code{renderUI} is used in an
interactive R Markdown document.}
}
\description{
Create dynamic menu output (server side)
}
\examples{
## Only run these examples in interactive R sessions

if (interactive()) {
library(shiny)
# ========== Dynamic sidebarMenu ==========
ui <- dashboardPage(
  dashboardHeader(title = "Dynamic sidebar"),
  dashboardSidebar(
    sidebarMenuOutput("menu")
  ),
  dashboardBody()
)

server <- function(input, output) {
  output$menu <- renderMenu({
    sidebarMenu(
      menuItem("Menu item", icon = icon("calendar"))
    )
  })
}

shinyApp(ui, server)

# ========== Dynamic dropdownMenu ==========
# Example message data in a data frame
messageData <- data.frame(
  from = c("Admininstrator", "New User", "Support"),
  message = c(
    "Sales are steady this month.",
    "How do I register?",
    "The new server is ready."
  ),
  stringsAsFactors = FALSE
)

ui <- dashboardPage(
  dashboardHeader(
    title = "Dynamic menus",
    dropdownMenuOutput("messageMenu")
  ),
  dashboardSidebar(),
  dashboardBody(
    fluidRow(
      box(
        title = "Controls",
        sliderInput("slider", "Number of observations:", 1, 100, 50)
      )
    )
  )
)

server <- function(input, output) {
  output$messageMenu <- renderMenu({
    # Code to generate each of the messageItems here, in a list. messageData
    # is a data frame with two columns, 'from' and 'message'.
    # Also add on slider value to the message content, so that messages update.
    msgs <- apply(messageData, 1, function(row) {
      messageItem(
        from = row[["from"]],
        message = paste(row[["message"]], input$slider)
      )
    })

    dropdownMenu(type = "messages", .list = msgs)
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link{menuOutput}} for the corresponding client side function
  and examples.

Other menu outputs: \code{\link{dropdownMenuOutput}},
  \code{\link{menuItemOutput}}, \code{\link{menuOutput}},
  \code{\link{sidebarMenuOutput}}
}

